<?php

class WarrenCore_Elementor_Section_Handler {
	private static $instance;
	public $sections = array();
	public $columns  = array();

	public function __construct() {
		// section extension
		add_action( 'elementor/element/section/_section_responsive/after_section_end', array( $this, 'render_parallax_options' ), 10, 2 );
		add_action( 'elementor/element/section/_section_responsive/after_section_end', array( $this, 'render_offset_options' ), 10, 2 );
		add_action( 'elementor/element/section/_section_responsive/after_section_end', array( $this, 'render_grid_options' ), 10, 2 );
		add_action( 'elementor/frontend/section/before_render', array( $this, 'section_before_render' ) );
		add_action( 'elementor/frontend/element/before_render', array( $this, 'section_before_render' ) );

		// column extension
		add_action( 'elementor/element/column/_section_responsive/after_section_end', array( $this, 'render_background_text_options' ), 10, 2 );
		add_action( 'elementor/element/column/_section_responsive/after_section_end', array( $this, 'render_sticky_options' ), 10, 2 );
		add_action( 'elementor/frontend/column/before_render', array( $this, 'column_before_render' ) );
		add_action( 'elementor/frontend/element/before_render', array( $this, 'column_before_render' ) );

		// common stuff
		add_action( 'elementor/frontend/before_enqueue_styles', array( $this, 'enqueue_styles' ), 9 );
		add_action( 'elementor/frontend/before_enqueue_scripts', array( $this, 'enqueue_scripts' ), 9 );
	}

	/**
	 * @return WarrenCore_Elementor_Section_Handler
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	// section extension
	public function render_parallax_options( $section, $args ) {
		$section->start_controls_section(
			'qodef_parallax',
			array(
				'label' => esc_html__( 'Warren Parallax', 'warren-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			)
		);

		$section->add_control(
			'qodef_parallax_type',
			array(
				'label'       => esc_html__( 'Enable Parallax', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'no',
				'options'     => array(
					'no'       => esc_html__( 'No', 'warren-core' ),
					'parallax' => esc_html__( 'Yes', 'warren-core' ),
				),
				'render_type' => 'template',
			)
		);

		$section->add_control(
			'qodef_parallax_image',
			array(
				'label'       => esc_html__( 'Parallax Background Image', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'condition'   => array(
					'qodef_parallax_type' => 'parallax',
				),
				'render_type' => 'template',
			)
		);

		$section->end_controls_section();
	}

	public function render_offset_options( $section, $args ) {
		$section->start_controls_section(
			'qodef_offset',
			array(
				'label' => esc_html__( 'Warren Offset Image', 'warren-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			)
		);

		$section->add_control(
			'qodef_offset_type',
			array(
				'label'       => esc_html__( 'Enable Offset Image', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'no',
				'options'     => array(
					'no'     => esc_html__( 'No', 'warren-core' ),
					'offset' => esc_html__( 'Yes', 'warren-core' ),
				),
				'render_type' => 'template',
			)
		);

		$section->add_control(
			'qodef_offset_type_disable_from',
			array(
				'label'        => esc_html__( 'Offset Image Disable From', 'warren-core' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => '',
				'options'      => array(
					''     => esc_html__( 'Default', 'warren-core' ),
					'1512' => esc_html__( 'Screen Size 1512', 'warren-core' ),
					'1368' => esc_html__( 'Screen Size 1368', 'warren-core' ),
					'1200' => esc_html__( 'Screen Size 1200', 'warren-core' ),
					'1024' => esc_html__( 'Screen Size 1024', 'warren-core' ),
					'880'  => esc_html__( 'Screen Size 880', 'warren-core' ),
				),
				'condition'    => array(
					'qodef_offset_type' => 'offset',
				),
				'prefix_class' => 'qodef-offset-image-disabled--',
			)
		);

		$repeater = new Elementor\Repeater();

		$repeater->add_control(
			'qodef_offset_image',
			array(
				'label'       => esc_html__( 'Offset Image', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'render_type' => 'template',
			)
		);

		$repeater->add_control(
			'qodef_offset_movement',
			array(
				'label'       => esc_html__( 'Enable Offset Movement', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '',
				'options'     => array(
					''       => esc_html__( 'No', 'warren-core' ),
					'scroll' => esc_html__( 'Scroll', 'warren-core' ),
					'cursor' => esc_html__( 'Cursor', 'warren-core' ),
				),
				'render_type' => 'template',
			)
		);

		$repeater->add_control(
			'qodef_offset_appear',
			array(
				'label'        => esc_html__( 'Enable Offset Appear', 'warren-core' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => '',
				'options'      => array(
					''       => esc_html__( 'No', 'warren-core' ),
					'appear' => esc_html__( 'Yes', 'warren-core' ),
				),
				'render_type'  => 'template',
			)
		);

		$repeater->add_control(
			'qodef_offset_vertical_anchor',
			array(
				'label'   => esc_html__( 'Offset Image Vertical Anchor', 'warren-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'top'    => esc_html__( 'Top', 'warren-core' ),
					'bottom' => esc_html__( 'Bottom', 'warren-core' ),
				),
				'default' => 'top',
			)
		);

		$repeater->add_control(
			'qodef_offset_vertical_position',
			array(
				'label'   => esc_html__( 'Offset Image Vertical Position', 'warren-core' ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => '25%',
			)
		);

		$repeater->add_control(
			'qodef_offset_horizontal_anchor',
			array(
				'label'   => esc_html__( 'Offset Image Horizontal Anchor', 'warren-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'left'  => esc_html__( 'Left', 'warren-core' ),
					'right' => esc_html__( 'Right', 'warren-core' ),
				),
				'default' => 'left',
			)
		);

		$repeater->add_control(
			'qodef_offset_horizontal_position',
			array(
				'label'   => esc_html__( 'Offset Image Horizontal Position', 'warren-core' ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => '25%',
			)
		);

		$section->add_control(
			'qodef_offset_image_items',
			array(
				'label'       => esc_html__( 'Offset Image Items', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => esc_html__( 'Item', 'warren-core' ),
				'condition'   => array(
					'qodef_offset_type' => 'offset',
				),
			)
		);

		$section->end_controls_section();
	}

	public function render_grid_options( $section, $args ) {
		$section->start_controls_section(
			'qodef_grid_row',
			array(
				'label' => esc_html__( 'Warren Grid', 'warren-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			)
		);

		$section->add_control(
			'qodef_enable_grid_row',
			array(
				'label'        => esc_html__( 'Make this row "In Grid"', 'warren-core' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => '',
				'options'      => array(
					''     => esc_html__( 'No', 'warren-core' ),
					'grid' => esc_html__( 'Yes', 'warren-core' ),
				),
				'prefix_class' => 'qodef-elementor-content-',
			)
		);

		$section->add_control(
			'qodef_grid_row_behavior',
			array(
				'label'        => esc_html__( 'Grid Row Behavior', 'warren-core' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => '',
				'options'      => array(
					''      => esc_html__( 'Default', 'warren-core' ),
					'right' => esc_html__( 'Extend Grid Right', 'warren-core' ),
					'left'  => esc_html__( 'Extend Grid Left', 'warren-core' ),
				),
				'condition'    => array(
					'qodef_enable_grid_row' => 'grid',
				),
				'prefix_class' => 'qodef-extended-grid qodef-extended-grid--',
			)
		);

		$section->add_control(
			'qodef_grid_row_behavior_disable_from',
			array(
				'label'        => esc_html__( 'Grid Row Behavior Disable From', 'warren-core' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => '',
				'options'      => array(
					''     => esc_html__( 'Default', 'warren-core' ),
					'1512' => esc_html__( 'Screen Size 1512', 'warren-core' ),
					'1368' => esc_html__( 'Screen Size 1368', 'warren-core' ),
					'1200' => esc_html__( 'Screen Size 1200', 'warren-core' ),
					'1024' => esc_html__( 'Screen Size 1024', 'warren-core' ),
					'880'  => esc_html__( 'Screen Size 880', 'warren-core' ),
				),
				'condition'    => array(
					'qodef_grid_row_behavior' => array ( 'left', 'right' ),
				),
				'prefix_class' => 'qodef-extended-grid-disabled--',
			)
		);

		$section->end_controls_section();
	}

	public function section_before_render( $widget ) {
		$data     = $widget->get_data();
		$type     = isset( $data['elType'] ) ? $data['elType'] : 'section';
		$settings = $data['settings'];

		if ( 'section' === $type ) {
			if ( isset( $settings['qodef_parallax_type'] ) && 'parallax' === $settings['qodef_parallax_type'] ) {
				$parallax_type  = $widget->get_settings_for_display( 'qodef_parallax_type' );
				$parallax_image = $widget->get_settings_for_display( 'qodef_parallax_image' );

				if ( ! in_array( $data['id'], $this->sections, true ) ) {
					$this->sections[ $data['id'] ][] = array(
						'parallax_type'  => $parallax_type,
						'parallax_image' => $parallax_image,
					);
				}
			}

			if ( isset( $settings['qodef_offset_type'] ) && 'offset' === $settings['qodef_offset_type'] ) {

				$offset_type        = $widget->get_settings_for_display( 'qodef_offset_type' );
				$offset_image_items = $widget->get_settings_for_display( 'qodef_offset_image_items' );

				if ( ! in_array( $data['id'], $this->sections, true ) ) {
					$this->sections[ $data['id'] ][] = array(
						'offset_type'        => $offset_type,
						'offset_image_items' => $offset_image_items,
					);
				}
			}
		}
	}

	// column extension
	public function render_background_text_options( $column, $args ) {
		$column->start_controls_section(
			'qodef_background_text_holder',
			array(
				'label' => esc_html__( 'Warren Core Background Text', 'warren-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			)
		);

		$column->add_control(
			'qodef_background_text_enable',
			array(
				'label'       => esc_html__( 'Enable Background Text', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'no',
				'options'     => array(
					'no'  => esc_html__( 'No', 'warren-core' ),
					'yes' => esc_html__( 'Yes', 'warren-core' ),
				),
				'render_type' => 'template',
			)
		);

		$column->add_control(
			'qodef_background_text',
			array(
				'label'       => esc_html__( 'Text', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => array(
					'qodef_background_text_enable' => 'yes',
				),
				'render_type' => 'template',
			)
		);

		$column->add_control(
			'qodef_background_text_color',
			array(
				'label'       => esc_html__( 'Text Color', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::COLOR,
				'condition'   => array(
					'qodef_background_text_enable' => 'yes',
				),
				'render_type' => 'template',
			)
		);

		$column->add_control(
			'qodef_background_text_size',
			array(
				'label'       => esc_html__( 'Text Size (px)', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => array(
					'qodef_background_text_enable' => 'yes',
				),
				'render_type' => 'template',
			)
		);

		$column->add_control(
			'qodef_background_text_size_1512',
			array(
				'label'       => esc_html__( 'Text Size - between 1512 and 1369 (px)', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => array(
					'qodef_background_text_enable' => 'yes',
				),
				'render_type' => 'template',
			)
		);

		$column->add_control(
			'qodef_background_text_size_1368',
			array(
				'label'       => esc_html__( 'Text Size - between 1368 and 1201 (px)', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => array(
					'qodef_background_text_enable' => 'yes',
				),
				'render_type' => 'template',
			)
		);

		$column->add_control(
			'qodef_background_text_size_1200',
			array(
				'label'       => esc_html__( 'Text Size - from 1200 (px)', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => array(
					'qodef_background_text_enable' => 'yes',
				),
				'render_type' => 'template',
			)
		);

		$column->add_control(
			'qodef_background_text_vertical_offset',
			array(
				'label'       => esc_html__( 'Vertical Offset (px)', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => array(
					'qodef_background_text_enable' => 'yes',
				),
				'render_type' => 'template',
			)
		);

		$column->add_control(
			'qodef_background_text_vertical_offset_1512',
			array(
				'label'       => esc_html__( 'Vertical Offset - between 1512 and 1369 (px)', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => array(
					'qodef_background_text_enable' => 'yes',
				),
				'render_type' => 'template',
			)
		);

		$column->add_control(
			'qodef_background_text_vertical_offset_1368',
			array(
				'label'       => esc_html__( 'Vertical Offset - between 1368 and 1201 (px)', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => array(
					'qodef_background_text_enable' => 'yes',
				),
				'render_type' => 'template',
			)
		);

		$column->add_control(
			'qodef_background_text_vertical_offset_1200',
			array(
				'label'       => esc_html__( 'Vertical Offset - from 1200 (px)', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => array(
					'qodef_background_text_enable' => 'yes',
				),
				'render_type' => 'template',
			)
		);

		$column->add_control(
			'qodef_background_text_horizontal_align',
			array(
				'label'       => esc_html__( 'Horizontal Align', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'flex-start',
				'options'     => array(
					'flex-start' => esc_html__( 'Left', 'warren-core' ),
					'center'     => esc_html__( 'Center', 'warren-core' ),
					'flex-end'   => esc_html__( 'Right', 'warren-core' ),
				),
				'condition'   => array(
					'qodef_background_text_enable' => 'yes',
				),
				'render_type' => 'template',
			)
		);

		$column->add_control(
			'qodef_background_text_vertical_align',
			array(
				'label'       => esc_html__( 'Vertical Align', 'warren-core' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'flex-start',
				'options'     => array(
					'flex-start' => esc_html__( 'Top', 'warren-core' ),
					'center'     => esc_html__( 'Middle', 'warren-core' ),
					'flex-end'   => esc_html__( 'Bottom', 'warren-core' ),
				),
				'condition'   => array(
					'qodef_background_text_enable' => 'yes',
				),
				'render_type' => 'template',
			)
		);

		$column->end_controls_section();
	}

	public function render_sticky_options( $column, $args ) {
		$column->start_controls_section(
			'qodef_sticky_column',
			array(
				'label' => esc_html__( 'Warren Core Sticky Column', 'warren-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			)
		);

		$column->add_control(
			'qodef_sticky_column_behavior',
			array(
				'label'        => esc_html__( 'Enable Sticky Column', 'warren-core' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => '',
				'options'      => array(
					''       => esc_html__( 'No', 'warren-core' ),
					'enable' => esc_html__( 'Yes', 'warren-core' ),
				),
				'prefix_class' => 'qodef-sticky-column--',
			)
		);

		$column->add_control(
			'qodef_sticky_column_behavior_snap_to',
			array(
				'label'        => esc_html__( 'Sticky Column Behavior Snap To', 'warren-core' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => '',
				'options'      => array(
					''       => esc_html__( 'Middle', 'warren-core' ),
					'top'    => esc_html__( 'Top', 'warren-core' ),
					'bottom' => esc_html__( 'Bottom', 'warren-core' ),
				),
				'condition'    => array(
					'qodef_sticky_column_behavior' => 'enable',
				),
				'prefix_class' => 'qodef-sticky-column-snap-to--',
			)
		);

		$column->add_control(
			'qodef_sticky_column_behavior_disable_from',
			array(
				'label'        => esc_html__( 'Sticky Column Behavior Disable From', 'warren-core' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => '',
				'options'      => array(
					''     => esc_html__( 'Default', 'warren-core' ),
					'1512' => esc_html__( 'Screen Size 1512', 'warren-core' ),
					'1368' => esc_html__( 'Screen Size 1368', 'warren-core' ),
					'1200' => esc_html__( 'Screen Size 1200', 'warren-core' ),
					'1024' => esc_html__( 'Screen Size 1024', 'warren-core' ),
					'880'  => esc_html__( 'Screen Size 880', 'warren-core' ),
				),
				'condition'    => array(
					'qodef_sticky_column_behavior' => 'enable',
				),
				'prefix_class' => 'qodef-sticky-column-disabled--',
			)
		);

		$column->end_controls_section();
	}

	public function column_before_render( $widget ) {
		$data     = $widget->get_data();
		$type     = isset( $data['elType'] ) ? $data['elType'] : 'column';
		$settings = $data['settings'];

		if ( 'column' === $type ) {
			if ( isset( $settings['qodef_background_text_enable'] ) && 'yes' === $settings['qodef_background_text_enable'] ) {
				$background_text                      = $widget->get_settings_for_display( 'qodef_background_text' );
				$background_text_color                = $widget->get_settings_for_display( 'qodef_background_text_color' );
				$background_text_size                 = $widget->get_settings_for_display( 'qodef_background_text_size' );
				$background_text_size_1512            = $widget->get_settings_for_display( 'qodef_background_text_size_1512' );
				$background_text_size_1368            = $widget->get_settings_for_display( 'qodef_background_text_size_1368' );
				$background_text_size_1200            = $widget->get_settings_for_display( 'qodef_background_text_size_1200' );
				$background_text_vertical_offset      = $widget->get_settings_for_display( 'qodef_background_text_vertical_offset' );
				$background_text_vertical_offset_1512 = $widget->get_settings_for_display( 'qodef_background_text_vertical_offset_1512' );
				$background_text_vertical_offset_1368 = $widget->get_settings_for_display( 'qodef_background_text_vertical_offset_1368' );
				$background_text_vertical_offset_1200 = $widget->get_settings_for_display( 'qodef_background_text_vertical_offset_1200' );
				$background_text_horizontal_align     = $widget->get_settings_for_display( 'qodef_background_text_horizontal_align' );
				$background_text_vertical_align       = $widget->get_settings_for_display( 'qodef_background_text_vertical_align' );

				if ( ! in_array( $data['id'], $this->columns, true ) ) {
					$this->columns[ $data['id'] ] = array(
						$background_text,
						$background_text_color,
						$background_text_size,
						$background_text_size_1512,
						$background_text_size_1368,
						$background_text_size_1200,
						$background_text_vertical_offset,
						$background_text_vertical_offset_1512,
						$background_text_vertical_offset_1368,
						$background_text_vertical_offset_1200,
						$background_text_horizontal_align,
						$background_text_vertical_align,
					);
				}

				$widget->add_render_attribute( '_wrapper', 'class', 'qodef-background-text' );
			}
		}
	}

	// common stuff
	public function enqueue_styles() {
		wp_enqueue_style( 'warren-core-elementor', WARREN_CORE_PLUGINS_URL_PATH . '/elementor/assets/css/elementor.min.css' );
	}

	public function enqueue_scripts() {
		$elementor_elements_caching = get_option( 'elementor_experiment-e_element_cache' );

		if ( 'inactive' !== $elementor_elements_caching ) {
			if ( 0 === count( $this->sections ) ) {
				$this->sections = get_post_meta( get_the_ID(), 'qodef_elementor_section_data_meta', true );
			} else {
				update_post_meta( get_the_ID(), 'qodef_elementor_section_data_meta', $this->sections );
			}

			if ( 0 === count( $this->columns ) ) {
				$this->columns = get_post_meta( get_the_ID(), 'qodef_elementor_column_data_meta', true );
			} else {
				update_post_meta( get_the_ID(), 'qodef_elementor_column_data_meta', $this->columns );
			}
		}

		wp_enqueue_script( 'warren-core-elementor', WARREN_CORE_PLUGINS_URL_PATH . '/elementor/assets/js/elementor.min.js', array( 'jquery', 'elementor-frontend' ) );

		$elementor_global_vars = array(
			'elementorSectionHandler' => $this->sections,
			'elementorColumnHandler'  => $this->columns,
		);

		wp_localize_script(
			'warren-core-elementor',
			'qodefElementorGlobal',
			array(
				'vars' => $elementor_global_vars,
			)
		);
	}
}

if ( ! function_exists( 'warren_core_init_elementor_section_handler' ) ) {
	/**
	 * Function that initialize main page builder handler
	 */
	function warren_core_init_elementor_section_handler() {
		WarrenCore_Elementor_Section_Handler::get_instance();
	}

	add_action( 'init', 'warren_core_init_elementor_section_handler', 1 );
}
