<?php

if ( ! function_exists( 'warren_core_register_course_for_meta_options' ) ) {
	function warren_core_register_course_for_meta_options( $post_types ) {
		$post_types[] = 'course';

		return $post_types;
	}

	add_filter( 'qode_framework_filter_meta_box_save', 'warren_core_register_course_for_meta_options' );
	add_filter( 'qode_framework_filter_meta_box_remove', 'warren_core_register_course_for_meta_options' );
}

if ( ! function_exists( 'warren_core_add_course_custom_post_type' ) ) {
	/**
	 * Function that adds custom post type
	 *
	 * @param array $cpts
	 *
	 * @return array
	 */
	function warren_core_add_course_custom_post_type( $cpts ) {
		$cpts[] = 'WarrenCore_Course_CPT';

		return $cpts;
	}

	add_filter( 'warren_core_filter_register_custom_post_types', 'warren_core_add_course_custom_post_type' );
}

if ( class_exists( 'QodeFrameworkCustomPostType' ) ) {
	class WarrenCore_Course_CPT extends QodeFrameworkCustomPostType {

		public function map_post_type() {
			$name = esc_html__( 'Course', 'warren-core' );
			$this->set_base( 'course' );
			$this->set_menu_position( 5 );
			$this->set_menu_icon( 'dashicons-welcome-learn-more' );
			$this->set_slug( 'course' );
			$this->set_name( $name );
			$this->set_path( WARREN_CORE_PLUGINS_PATH . '/lms/post-types/course' );
			$this->set_labels(
				array(
					'name'          => esc_html__( 'Warren Course', 'warren-core' ),
					'singular_name' => esc_html__( 'Course', 'warren-core' ),
					'add_item'      => esc_html__( 'New Course', 'warren-core' ),
					'add_new_item'  => esc_html__( 'Add New Course', 'warren-core' ),
					'edit_item'     => esc_html__( 'Edit Course', 'warren-core' ),
				)
			);

			$this->add_post_taxonomy(
				array(
					'base'          => 'course-category',
					'slug'          => 'course-category',
					'singular_name' => esc_html__( 'Category', 'warren-core' ),
					'plural_name'   => esc_html__( 'Categories', 'warren-core' ),
				)
			);
			$this->add_post_taxonomy(
				array(
					'base'          => 'course-tag',
					'slug'          => 'course-tag',
					'singular_name' => esc_html__( 'Tag', 'warren-core' ),
					'plural_name'   => esc_html__( 'Tags', 'warren-core' ),
				)
			);
		}
	}
}
