<?php

if ( ! function_exists( 'warren_core_add_course_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_course_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => WARREN_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'course',
				'layout'      => 'tabbed',
				'icon'        => 'fa fa-cog',
				'title'       => esc_html__( 'Course', 'warren-core' ),
				'description' => esc_html__( 'Global settings related to course', 'warren-core' ),
			)
		);

		if ( $page ) {
			$archive_tab = $page->add_tab_element(
				array(
					'name'        => 'tab-archive',
					'icon'        => 'fa fa-cog',
					'title'       => esc_html__( 'Course List', 'warren-core' ),
					'description' => esc_html__( 'Settings related to course archive pages', 'warren-core' ),
				)
			);

			// Hook to include additional options after archive module options
			do_action( 'warren_core_action_after_course_options_archive', $archive_tab );

			$single_tab = $page->add_tab_element(
				array(
					'name'        => 'tab-single',
					'icon'        => 'fa fa-cog',
					'title'       => esc_html__( 'Course Single', 'warren-core' ),
					'description' => esc_html__( 'Settings related to course single pages', 'warren-core' ),
				)
			);

			$single_tab->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_course_single_show_only_parent_category',
					'title'         => esc_html__( 'Show Only Parent Category', 'warren-core' ),
					'description'   => esc_html__( 'Enabling this option will show only parent categories info on your course single page', 'warren-core' ),
					'default_value' => 'no',
				)
			);

			$single_tab->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_course_single_show_members',
					'title'         => esc_html__( 'Show Members Tab', 'warren-core' ),
					'description'   => esc_html__( 'Enabling this option will show members tab', 'warren-core' ),
					'default_value' => 'yes',
				)
			);

			// Hook to include additional options after single module options
			do_action( 'warren_core_action_after_course_options_single', $single_tab );

			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_course_options_map', $page );
		}
	}

	add_action( 'warren_core_action_default_options_init', 'warren_core_add_course_options', warren_core_get_admin_options_map_position( 'course' ) );
}
