<?php

if ( ! function_exists( 'warren_core_add_course_members_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_course_members_meta_box( $page ) {
		if ( $page ) {
			$members_tab = $page->add_tab_element(
				array(
					'name'  => 'tab-members',
					'icon'  => 'fa fa-cog',
					'title' => esc_html__( 'Members', 'warren-core' ),
				)
			);

			$members_tab->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_course_single_show_members',
					'title'      => esc_html__( 'Show Members Tab', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'yes_no', true ),
				)
			);

			$members_tab->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_course_members_description',
					'title'       => esc_html__( 'Members Description', 'warren-core' ),
					'description' => esc_html__( 'Enter description for members', 'warren-core' ),
					'dependency'  => array(
						'hide' => array(
							'qodef_course_single_show_members' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$members_repeater = $members_tab->add_repeater_element(
				array(
					'layout'      => 'columns-layout',
					'name'        => 'qodef_course_members_repeater',
					'title'       => esc_html__( 'Course Members', 'warren-core' ),
					'description' => esc_html__( 'This part should be used for displaying members and changing status for inactive users.', 'warren-core' ),
					'args'        => array(
						'custom_class' => 'qodef-presentable',
					),
				)
			);

			$members_repeater->add_field_element(
				array(
					'field_type' => 'hidden',
					'name'       => 'qodef_course_member_id',
					'title'      => esc_html__( 'User ID', 'warren-core' ),
					'args'       => array(
						'col_width' => '3',
						'readonly'  => true,
					),
				)
			);

			$members_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_course_member_name',
					'title'      => esc_html__( 'Name', 'warren-core' ),
					'args'       => array(
						'col_width' => '4',
						'readonly'  => true,
					),
				)
			);

			$members_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_course_member_email',
					'title'      => esc_html__( 'Email', 'warren-core' ),
					'args'       => array(
						'col_width' => '4',
						'readonly'  => true,
					),
				)
			);

			$members_repeater->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_course_member_status',
					'title'      => esc_html__( 'Status in Course', 'warren-core' ),
					'options'    => array(
						'bought'   => esc_html__( 'Bought', 'warren-core' ),
						'enrolled' => esc_html__( 'Enrolled', 'warren-core' ),
						'inactive' => esc_html__( 'Inactive', 'warren-core' ),
					),
					'args'       => array(
						'col_width' => '4',
					),
				)
			);

		}
	}

	add_action( 'warren_core_action_after_course_meta_box_map', 'warren_core_add_course_members_meta_box' );
}
