<?php

if ( ! function_exists( 'warren_core_add_course_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_course_meta_box() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'  => array( 'course' ),
				'type'   => 'meta',
				'slug'   => 'course',
				'title'  => esc_html__( 'Course Section', 'warren-core' ),
				'layout' => 'tabbed',
			)
		);

		if ( $page ) {

			$general_tab = $page->add_tab_element(
				array(
					'name'  => 'tab-general',
					'icon'  => 'fa fa-cog',
					'title' => esc_html__( 'General', 'warren-core' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_course_list_image',
					'title'       => esc_html__( 'Course List Image', 'warren-core' ),
					'description' => esc_html__( 'Upload image to be displayed on course list instead of featured image', 'warren-core' ),
				)
			);

			$instructors = warren_core_course_get_instructors();

			if ( count( $instructors ) ) {

				$general_tab->add_field_element(
					array(
						'field_type' => 'select',
						'name'       => 'qodef_course_instructor',
						'title'      => esc_html__( 'Course Instructor', 'warren-core' ),
						'options'    => $instructors,
					)
				);
			}

			$first_row = $general_tab->add_row_element(
				array(
					'name' => 'qodef_course_first_row',
				)
			);

			$first_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_course_duration',
					'title'      => esc_html__( 'Course Duration', 'warren-core' ),
					'args'       => array(
						'col_width' => 6,
					),
				)
			);

			$first_row->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_course_duration_unit',
					'title'      => esc_html__( 'Course Duration Unit', 'warren-core' ),
					'options'    => array(
						'minutes' => esc_html__( 'Minutes', 'warren-core' ),
						'hours'   => esc_html__( 'Hours', 'warren-core' ),
						'days'    => esc_html__( 'Days', 'warren-core' ),
						'weeks'   => esc_html__( 'Weeks', 'warren-core' ),
					),
					'args'       => array(
						'col_width' => 6,
					),
				)
			);

			$second_row = $general_tab->add_row_element(
				array(
					'name' => 'qodef_course_second_row',
				)
			);

			$second_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_course_maximum_students',
					'title'      => esc_html__( 'Maximum Students', 'warren-core' ),
					'args'       => array(
						'col_width' => 6,
					),
				)
			);

			$second_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_course_retake_number',
					'title'      => esc_html__( 'Number of Retakes', 'warren-core' ),
					'args'       => array(
						'col_width' => 6,
					),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_course_passing_percentage',
					'title'       => esc_html__( 'Passing Percentage', 'warren-core' ),
					'description' => esc_html__( 'Set percentage required to pass the course', 'warren-core' ),
					'args'        => array(
						'suffix' => '%',
					),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_course_free',
					'title'         => esc_html__( 'Free Course', 'warren-core' ),
					'description'   => esc_html__( 'Enable this option to set course to be free', 'warren-core' ),
					'default_value' => 'no',
				)
			);

			$price_section = $general_tab->add_section_element(
				array(
					'name'       => 'qodef_course_price_section',
					'dependency' => array(
						'show' => array(
							'qodef_course_free' => array(
								'values'        => 'no',
								'default_value' => 'no',
							),
						),
					),
				)
			);

			$price_section->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_course_price',
					'title'      => esc_html__( 'Price', 'warren-core' ),
					'args'       => array(
						'col_width' => '6',
					),
				)
			);

			$price_section->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_course_discount_price',
					'title'      => esc_html__( 'Discount Price', 'warren-core' ),
					'args'       => array(
						'col_width' => '6',
					),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_course_featured',
					'title'         => esc_html__( 'Featured Course', 'warren-core' ),
					'description'   => esc_html__( 'Enable this option to set course to be featured', 'warren-core' ),
					'default_value' => 'no',
				)
			);
			$general_tab->add_field_element(
				array(
					'field_type'    => 'color',
					'name'          => 'qodef_course_background_color',
					'title'         => esc_html__( 'Item Background Color', 'warren-core' ),
					'description'   => esc_html__( 'Select background color for this item.', 'warren-core' ),
					'default_value' => 'no',
				)
			);
			$general_tab->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_course_background_image',
					'title'      => esc_html__( 'Item Background Image', 'warren-core' ),
				)
			);
			$general_tab->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_course_item_skin',
					'title'         => esc_html__( 'Enable Light Skin For Content On Item', 'warren-core' ),
					'description'   => esc_html__( 'Enable this option to set light skin content on item', 'warren-core' ),
					'default_value' => 'no',
				)
			);

			$courses = qode_framework_get_cpt_items( 'course', array(), true );

			$general_tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_course_prerequired',
					'title'       => esc_html__( 'Pre-required Course', 'warren-core' ),
					'description' => esc_html__( 'Select course that needs to be completed before attending', 'warren-core' ),
					'options'     => $courses,
				)
			);

			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_course_meta_box_map', $page );
		}
	}

	add_action( 'warren_core_action_default_meta_boxes_init', 'warren_core_add_course_meta_box' );
}

if ( ! function_exists( 'warren_core_include_general_meta_boxes_for_course_single' ) ) {
	/**
	 * Function that add general meta box options for this module
	 */
	function warren_core_include_general_meta_boxes_for_course_single() {
		$callbacks = warren_core_general_meta_box_callbacks();

		if ( ! empty( $callbacks ) ) {
			foreach ( $callbacks as $callback ) {
				add_action( 'warren_core_action_after_course_meta_box_map', $callback );
			}
		}
	}

	add_action( 'warren_core_action_default_meta_boxes_init', 'warren_core_include_general_meta_boxes_for_course_single', 8 ); // Permission 8 is set in order to load it before default meta box function
}
