<?php

if ( ! function_exists( 'warren_core_include_course_payment_class' ) ) {
	/**
	 * Include custom post type payment classes
	 */
	function warren_core_include_course_payment_class() {
		if ( qode_framework_is_installed( 'checkout' ) ) {
			require_once WARREN_CORE_PLUGINS_PATH . '/lms/post-types/course/payment/class-wc-product-course.php';
			require_once WARREN_CORE_PLUGINS_PATH . '/lms/post-types/course/payment/class-wc-order-item-course.php';
			require_once WARREN_CORE_PLUGINS_PATH . '/lms/post-types/course/payment/class-wc-order-item-course-data-store.php';
			require_once WARREN_CORE_PLUGINS_PATH . '/lms/post-types/course/payment/class-wc-course-data-store-cpt.php';
		}
	}

	add_action( 'wp_loaded', 'warren_core_include_course_payment_class' );
}

if ( ! function_exists( 'warren_core_add_course_to_post_types_payment' ) ) {
	/**
	 * Add custom post type into payment list
	 *
	 * @param array $post_types
	 *
	 * @return array
	 */
	function warren_core_add_course_to_post_types_payment( $post_types ) {

		if ( qode_framework_is_installed( 'checkout' ) ) {
			$post_types[] = 'course';
		}

		return $post_types;
	}

	add_filter( 'warren_core_filter_checkout_integration_post_types', 'warren_core_add_course_to_post_types_payment', 100 );
}

if ( ! function_exists( 'warren_core_set_notice_for_course_page' ) ) {
	/**
	 * Include default WooCommerce notice template into custom post type content
	 */
	function warren_core_set_notice_for_course_page() {

		if ( qode_framework_is_installed( 'checkout' ) ) {
			add_action( 'warren_core_action_before_course_post_content', 'wc_print_notices', 10 );
		}
	}

	add_action( 'wp', 'warren_core_set_notice_for_course_page' );
}

if ( ! function_exists( 'warren_core_get_course_book_now_form' ) ) {
	/**
	 * Add reservation form button trigger
	 *
	 * @param int $quantity_value
	 */
	function warren_core_get_course_book_now_form( $quantity_value ) {
		if ( qode_framework_is_installed( 'checkout' ) ) {
			warren_core_get_checkout_buy_item_form(
				array(
					'layout'         => 'content',
					'quantity_value' => $quantity_value,
				),
				array(
					'input_text' => esc_html__( 'Buy Now', 'warren-core' ),
				)
			);
		} else {
			esc_html_e( 'Please install a WooCommerce plugin in order to enable booking functionality.', 'warren-core' );
		}
	}
}

if ( ! function_exists( 'warren_core_add_to_cart_course_action' ) ) {
	/**
	 * Collect required information about custom post type and add it item into the cart
	 */
	function warren_core_add_to_cart_course_action() {
		$product_id        = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $_REQUEST['add-to-cart'] ) );
		$quantity          = empty( $_REQUEST['quantity'] ) ? 1 : wc_stock_amount( $_REQUEST['quantity'] );
		$passed_validation = true;

		if ( $passed_validation && WC()->cart->add_to_cart( $product_id, $quantity ) !== false ) {

			if ( 'yes' === get_option( 'woocommerce_cart_redirect_after_add' ) ) {
				wc_add_to_cart_message( array( $product_id => $quantity ), true );
			}

			wp_safe_redirect( wc_get_cart_url() );
			exit;
		}
	}

	add_action( 'woocommerce_add_to_cart_handler_course', 'warren_core_add_to_cart_course_action' );
}

if ( ! function_exists( 'warren_core_update_course_post_data' ) ) {
	/**
	 * Update custom post type reservation item meta on order status changed
	 *
	 * @param int $order_id
	 * @param string $status_from
	 * @param string $status_to
	 * @param WC_Order $order
	 */
	function warren_core_update_course_post_data( $order_id, $status_from, $status_to, $order ) {
		$items   = $order->get_items();
		$user_id = $order->get_user_id();

		if ( empty( $items ) ) {
			__return_empty_string();
		}

		if ( in_array( $status_to, array( 'processing', 'completed', 'pending', 'on-hold' ), true ) ) {

			foreach ( $items as $item ) {
				if ( is_a( $item, 'WC_Order_Item_Course' ) ) {
					$course_id = $item->get_product_id();

					$course_members = get_post_meta( $course_id, 'qodef_course_members_repeater', true );

					if ( ! empty( $course_members ) ) {

						$key = array_search( $user_id, array_column( $course_members, 'qodef_course_member_id' ), true );

						//if user doesn't exist, add it
						if ( false === $key ) {
							$user_data = get_userdata( $user_id );

							$course_members[] = array(
								'qodef_course_member_id'   => $user_id,
								'qodef_course_member_name' => $user_data->user_login,
								'qodef_course_member_email' => $user_data->user_email,
								'qodef_course_member_status' => 'bought',
							);
							update_post_meta( $course_id, 'qodef_course_members_repeater', $course_members );
						}
					} else {
						$user_data = get_userdata( $user_id );

						$course_members = array(
							array(
								'qodef_course_member_id'   => $user_id,
								'qodef_course_member_name' => $user_data->user_login,
								'qodef_course_member_email' => $user_data->user_email,
								'qodef_course_member_status' => 'bought',
							),
						);
						update_post_meta( $course_id, 'qodef_course_members_repeater', $course_members );
					}
				}
			}
		} elseif ( in_array( $status_to, array( 'cancelled', 'refunded', 'failed' ), true ) && in_array( $status_from, array( 'processing', 'completed', 'pending', 'on-hold' ), true ) ) {

			foreach ( $items as $item ) {
				if ( is_a( $item, 'WC_Order_Item_Course' ) ) {
					$course_id = $item->get_product_id();

					//delete user from course members if added
					$course_members = get_post_meta( $course_id, 'qodef_course_members_repeater', true );

					if ( ! empty( $course_members ) ) {

						foreach ( $course_members as $key => $course_member ) {
							if ( $user_id == $course_member['qodef_course_member_id'] ) {
								unset( $course_members[ $key ] );
								break;
							}
						}
						update_post_meta( $course_id, 'qodef_course_members_repeater', $course_members );
					}

					//delete course info
					$course_info = get_user_meta( $user_id, 'qodef_course_' . $course_id, true );

					if ( ! empty( $course_info ) ) {
						delete_user_meta( $user_id, 'qodef_course_' . $course_id );
					}

					//delete course id from course enrolled meta
					$courses_enrolled = get_user_meta( $user_id, 'qodef_courses_enrolled', true );

					if ( ! empty( $courses_enrolled ) ) {
						$key = array_search( $course_id, $courses_enrolled );

						if ( false !== $key ) {
							unset( $courses_enrolled[ $key ] );
						}

						update_user_meta( $user_id, 'qodef_courses_enrolled', $courses_enrolled );
					}
				}
			}
		}
	}

	add_action( 'woocommerce_order_status_changed', 'warren_core_update_course_post_data', 10, 4 );
}

if ( ! function_exists( 'warren_core_calculate_course_price' ) ) {
	function warren_core_calculate_course_price( $id = '' ) {
		$id = '' !== $id ? $id : get_the_ID();

		$free           = get_post_meta( $id, 'qodef_course_free', true );
		$price          = get_post_meta( $id, 'qodef_course_price', true );
		$discount_price = get_post_meta( $id, 'qodef_course_discount_price', true );

		$final_price = get_post_meta( $id, 'qodef_course_final_price', true );

		if ( empty( $final_price ) && 'yes' !== $free ) {

			if ( ! empty( $discount_price ) ) {
				$final_price = $discount_price;
			} else {
				$final_price = $price;
			}
		}

		return preg_replace( '/[^0-9.]/', '', $final_price );
	}
}

if ( ! function_exists( 'warren_core_get_course_in_stock' ) ) {
	function warren_core_get_course_in_stock( $id = '' ) {
		$id = '' !== $id ? $id : get_the_ID();

		$in_stock = get_post_meta( $id, 'qodef_course_maximum_students', true );

		return $in_stock;
	}
}

if ( ! function_exists( 'warren_core_get_user_courses' ) ) {
	/**
	 * Function that gets ids of all courses user has bought
	 *
	 * @return array of ids
	 */
	function warren_core_get_user_courses() {
		$courses = array(
			'bought'     => array(),
			'in_process' => array(),
		);

		$index = 'in_process';

		if ( qode_framework_is_installed( 'woocommerce' ) ) {
			$customer_orders = wc_get_orders(
				array(
					'customer' => get_current_user_id(),
				)
			);

			if ( ! empty( $customer_orders ) ) {
				foreach ( $customer_orders as $customer_order ) {
					$order       = wc_get_order( $customer_order->get_id() );
					$order_items = ! empty( $order ) ? $order->get_items() : array();

					switch ( $order->get_status() ) {
						case 'cancelled':
						case 'refunded':
						case 'failed':
							continue 2;
						case 'completed':
							$index = 'bought';
							break;
					}

					if ( ! empty( $order_items ) ) {
						foreach ( $order_items as $order_item ) {

							if ( 'course' === $order_item->get_type() ) {
								$courses[ $index ][] = $order_item->get_data()['product_id'];
							}
						}
					}
				}
			}
		}

		return $courses;
	}
}
