<?php

if ( ! function_exists( 'warren_core_add_course_profile_navigation_item' ) ) {
	function warren_core_add_course_profile_navigation_item( $items, $dashboard_url ) {
		$items['my-courses'] = array(
			'url'         => esc_url( add_query_arg( array( 'user-action' => 'my-courses' ), $dashboard_url ) ),
			'text'        => esc_html__( 'My Courses', 'warren-core' ),
			'user_action' => 'my-courses',
			'icon'        => '<svg aria-hidden="true" focusable="false" data-prefix="far" data-icon="clipboard" class="svg-inline--fa fa-clipboard fa-w-12" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path fill="currentColor" d="M336 64h-80c0-35.3-28.7-64-64-64s-64 28.7-64 64H48C21.5 64 0 85.5 0 112v352c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zM192 40c13.3 0 24 10.7 24 24s-10.7 24-24 24-24-10.7-24-24 10.7-24 24-24zm144 418c0 3.3-2.7 6-6 6H54c-3.3 0-6-2.7-6-6V118c0-3.3 2.7-6 6-6h42v36c0 6.6 5.4 12 12 12h168c6.6 0 12-5.4 12-12v-36h42c3.3 0 6 2.7 6 6z"></path></svg>',
		);

		return $items;
	}

	add_filter( 'warren_membership_filter_dashboard_navigation_action_pages', 'warren_core_add_course_profile_navigation_item', 10, 2 );
}

if ( ! function_exists( 'warren_core_add_course_profile_navigation_pages' ) ) {
	function warren_core_add_course_profile_navigation_pages( $html, $action ) {

		if ( 'my-courses' === $action ) {
			$all_user_courses = array();

			$user_courses_bought_buy = warren_core_get_user_courses();

			$all_user_courses['enrolled'] = get_user_meta( get_current_user_id(), 'qodef_courses_enrolled', true );

			if ( ! empty( $all_user_courses['enrolled'] ) ) {
				foreach ( $all_user_courses['enrolled'] as $course ) {
					$key = array_search( $course, $user_courses_bought_buy['bought'] );

					if ( false !== $key ) {
						unset( $user_courses_bought_buy['bought'][ $key ] );
					}
				}
			}
			$all_user_courses['bought']     = $user_courses_bought_buy['bought'];
			$all_user_courses['in_process'] = $user_courses_bought_buy['in_process'];

			$courses_params['courses'] = $all_user_courses;
			$html                      = warren_core_get_template_part( 'plugins/lms/post-types/course/profile', 'templates/my-courses', '', $courses_params );
		}

		return $html;
	}

	add_filter( 'warren_membership_filter_dashboard_page', 'warren_core_add_course_profile_navigation_pages', 10, 2 );
}
