<div class="qodef-profile-my-courses">
	<?php if ( ! empty( $courses['enrolled'] ) || ! empty( $courses['bought'] ) || ! empty( $courses['in_process'] ) ) { ?>
		<div class="qodef-m-section-title">
			<h3 class="qodef-m-title"><?php esc_html_e( 'Your Courses', 'warren-core' ); ?></h3>
		</div>
		<div class="qodef-m-items">
			<?php
			if ( ! empty( $courses['enrolled'] ) ) {
				foreach ( $courses['enrolled'] as $id ) {
					?>
					<div class="qodef-e-item">
						<?php
						if ( has_post_thumbnail( $id ) ) {
							echo get_the_post_thumbnail( $id, 'thumbnail' );
						}
						?>
						<h4 class="qodef-e-title">
							<a href="<?php the_permalink( $id ); ?>">
								<?php
								echo get_the_title( $id );
								esc_html_e( ' (Continue)', 'warren-core' );
								?>
							</a>
						</h4>
					</div>
					<?php
				}
			}
			?>
			<?php
			if ( ! empty( $courses['bought'] ) ) {
				foreach ( $courses['bought'] as $id ) {
					?>
					<div class="qodef-e-item">
						<?php
						if ( has_post_thumbnail( $id ) ) {
							echo get_the_post_thumbnail( $id, 'thumbnail' );
						}
						?>
						<h4 class="qodef-e-title">
							<a href="<?php the_permalink( $id ); ?>">
								<?php
								echo get_the_title( $id );
								esc_html_e( ' (Enroll)', 'warren-core' );
								?>
							</a>
						</h4>
					</div>
					<?php
				}
			}
			?>
			<?php
			if ( ! empty( $courses['in_process'] ) ) {
				foreach ( $courses['in_process'] as $id ) {
					?>
					<div class="qodef-e-item">
						<?php
						if ( has_post_thumbnail( $id ) ) {
							echo get_the_post_thumbnail( $id, 'thumbnail' );
						}
						?>
						<h4 class="qodef-e-title">
							<a href="<?php the_permalink( $id ); ?>">
								<?php
								echo get_the_title( $id );
								esc_html_e( ' (On Hold)', 'warren-core' );
								?>
							</a>
						</h4>
					</div>
					<?php
				}
			}
			?>
		</div>
	<?php } else { ?>
		<h3 class="qodef-m--not-found"><?php esc_html_e( 'You don\'t have any course yet.', 'warren-core' ); ?></h3>
	<?php } ?>
</div>
