<?php

if ( ! function_exists( 'warren_core_add_course_cpt_search_page_classes' ) ) {
	/**
	 * Function that add additional class name into global class list for body tag
	 *
	 * @param array $classes
	 *
	 * @return array
	 */
	function warren_core_add_course_cpt_search_page_classes( $classes ) {

		if ( is_search() && isset( $_GET['qodef-course-search'] ) ) {
			$classes[] = 'warren-core-course-archive';
		}

		return $classes;
	}

	add_filter( 'body_class', 'warren_core_add_course_cpt_search_page_classes' );
}

if ( ! function_exists( 'warren_core_set_course_search_sidebar_layout' ) ) {
	/**
	 * Function that return sidebar layout
	 *
	 * @param string $layout
	 *
	 * @return string
	 */
	function warren_core_set_course_search_sidebar_layout( $layout ) {

		if ( isset( $_GET['qodef-course-search'] ) ) {
			return 'no-sidebar';
		}

		return $layout;
	}

	add_filter( 'warren_filter_sidebar_layout', 'warren_core_set_course_search_sidebar_layout' );
}

if ( ! function_exists( 'warren_core_override_course_search_template_path' ) ) {
	function warren_core_override_course_search_template_path( $search ) {

		if ( isset( $_GET['qodef-course-search'] ) ) {
			$params = array();

			$filter_args = array(
				'category',
				'instructor',
				'price',
			);

			foreach ( $filter_args as $filter ) {
				$get_value = 'qodef-search-' . str_replace( '_', '-', $filter );

				if ( isset( $_GET[ $get_value ] ) ) {
					$params[ $filter ] = esc_attr( strip_tags( $_GET[ $get_value ] ) );
				}
			}

			return warren_core_get_template_part( 'plugins/lms/post-types/course/search', 'templates/search', '', $params );
		}

		return $search;
	}

	add_filter( 'warren_filter_search_archive_template', 'warren_core_override_course_search_template_path' );
}
