<?php

if ( ! function_exists( 'warren_core_add_course_list_shortcode' ) ) {
	/**
	 * Function that isadding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function warren_core_add_course_list_shortcode( $shortcodes ) {
		$shortcodes[] = 'WarrenCore_Course_List_Shortcode';

		return $shortcodes;
	}

	add_filter( 'warren_core_filter_register_shortcodes', 'warren_core_add_course_list_shortcode' );
}

if ( class_exists( 'WarrenCore_List_Shortcode' ) ) {
	class WarrenCore_Course_List_Shortcode extends WarrenCore_List_Shortcode {

		public function __construct() {
			$this->set_post_type( 'course' );
			$this->set_post_type_taxonomy( 'course-category' );
			$this->set_post_type_additional_taxonomies( array( 'course-tag' ) );
			$this->set_layouts( apply_filters( 'warren_core_filter_course_list_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'warren_core_filter_course_list_extra_options', array() ) );

			add_filter( 'warren_core_filter_map_additional_query_params', array(
				$this,
				'add_additional_query_params'
			), 10, 2 );
			add_action( 'warren_core_action_map_query_options_after_additional', array(
				$this,
				'add_additional_query_fields'
			) );
			add_filter( 'warren_core_filter_additional_query_args', array( $this, 'additional_query' ), 10, 3 );
			add_action( 'warren_core_action_map_additional_options_after_filter', array(
				$this,
				'add_additional_options'
			) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( WARREN_CORE_PLUGINS_URL_PATH . '/lms/post-types/course/shortcodes/course-list' );
			$this->set_base( 'warren_core_course_list' );
			$this->set_name( esc_html__( 'Course List', 'warren-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays list of course items', 'warren-core' ) );
			$this->set_scripts(
				apply_filters( 'warren_core_filter_course_list_register_scripts', array() )
			);
			$this->set_necessary_styles(
				apply_filters( 'warren_core_filter_course_list_register_styles', array() )
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'warren-core' ),
				)
			);

			$this->map_list_options(
				array(
					'exclude_behavior'      => array(
						'justified-gallery',
					),
					'include_slider_option' => array(
						'slider_centered_slides',
						'split_slider',
					),
				)
			);

			$order_by = array(
				'course-featured' => esc_html__( 'Featured Items First', 'warren-core' ),
				'price-high'      => esc_html__( 'Price from High to Low', 'warren-core' ),
				'price-low'       => esc_html__( 'Price From Low To High', 'warren-core' ),
			);

			$this->map_query_options(
				array(
					'include_order_by' => $order_by,
				)
			);
			$this->map_layout_options(
				array(
					'layouts' => $this->get_layouts(),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'excerpt_length',
					'title'      => esc_html__( 'Excerpt Length', 'warren-core' ),
					'group'      => esc_html__( 'Layout', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'main_title',
					'title'      => esc_html__( 'Main Title', 'warren-core' ),
					'group'      => esc_html__( 'Layout', 'warren-core' ),
					'dependency' => array(
						'show' => array(
							'behavior' => array(
								'default_value' => 'columns',
								'values'        => 'slider',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'main_subtitle',
					'title'      => esc_html__( 'Subtitle', 'warren-core' ),
					'group'      => esc_html__( 'Layout', 'warren-core' ),
					'dependency' => array(
						'show' => array(
							'behavior' => array(
								'default_value' => 'columns',
								'values'        => 'slider',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'title_holder_padding',
					'title'      => esc_html__( 'Title Holder Padding', 'warren-core' ),
					'group'      => esc_html__( 'Layout', 'warren-core' ),
					'dependency' => array(
						'show' => array(
							'behavior' => array(
								'default_value' => 'columns',
								'values'        => 'slider',
							),
						),
					),
				)
			);

			//options just for search
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'price',
					'title'      => esc_html__( 'Price', 'warren-core' ),
					'options'    => array(
						'all'  => esc_html__( 'All', 'warren-core' ),
						'free' => esc_html__( 'Free', 'warren-core' ),
						'paid' => esc_html__( 'Paid', 'warren-core' ),
					),
					'visibility' => array( 'map_for_page_builder' => false ),
				)
			);

			//options just for search
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'additional_instructor',
					'title'      => esc_html__( 'Additional Instructor', 'warren-core' ),
					'visibility' => array( 'map_for_page_builder' => false ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_skin_option',
					'title'         => esc_html__( 'Enable Skin Option', 'warren-core' ),
					'description'   => esc_html__( 'Enabling this option will allow the use of "Enable Light Skin For Content On Item" option in course list', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'no_yes' ),
					'default_value' => '',
					'group'         => esc_html__( 'Additional', 'warren-core' ),
				)
			);
			$this->map_additional_options();
			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'warren_core_course_list', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function load_assets() {
			parent::load_assets();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['post_type']       = $this->get_post_type();
			$atts['taxonomy_filter'] = $this->get_post_type_filter_taxonomy( $atts );

			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );

			$atts['holder_classes']      = $this->get_holder_classes( $atts );
			$atts['holder_styles']       = $this->get_holder_styles( $atts );
			$atts['title_holder_styles'] = $this->get_title_holder_styles( $atts );

			$atts['query_result']   = new WP_Query( warren_core_get_query_params( $atts ) );
			$atts['data_attr']      = warren_core_get_pagination_data( WARREN_CORE_REL_PATH, 'plugins/lms/post-types/course/shortcodes', 'course-list', 'post', $atts );
			$atts['unique']         = wp_unique_id();
			$atts['slider_attr']    = $this->get_slider_data(
				$atts,
				array(
					'unique'            => $atts['unique'],
					'outsideNavigation' => 'yes',
				)
			);
			$atts['this_shortcode'] = $this;

			return warren_core_get_template_part( 'plugins/lms/post-types/course/shortcodes/course-list', 'templates/content', $atts['behavior'], $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-course-list';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-item-layout--' . $atts['layout'] : '';


			$list_classes   = $this->get_list_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $list_classes );

			return implode( ' ', $holder_classes );
		}

		private function get_holder_styles( $atts ) {
			$holder_styles = array();

			$list_styles   = $this->get_list_styles( $atts );
			$holder_styles = array_merge( $holder_styles, $list_styles );

			return $holder_styles;
		}

		private function get_title_holder_styles( $atts ) {
			$holder_styles = array();

			if ( ! empty( $atts['title_holder_padding'] ) ) {
				$holder_styles[] = 'padding:' . $atts['title_holder_padding'];
			}

			return $holder_styles;
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$item_classes[] = 'qodef-course-item';

			$skin = get_post_meta( get_the_ID(), 'qodef_course_item_skin', true );

			if ( 'yes' === $atts['enable_skin_option'] && 'yes' == $skin ) {
				$item_classes[] = 'qodef-course-item-skin-light';
			}

			$list_item_classes = $this->get_list_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		public function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}

			return $styles;
		}

		public function get_list_item_style( $atts ) {
			$styles = array();

			$background_color = get_post_meta( get_the_ID(), 'qodef_course_background_color', true );

			if ( isset( $background_color ) && '' !== $background_color ) {
				$styles[] = 'background-color: ' . $background_color;
			}
			$background_image     = get_post_meta( get_the_ID(), 'qodef_course_background_image', true );
			$background_image_url = 'url(' . esc_url( wp_get_attachment_image_url( $background_image, 'full' ) ) . ')';

			if ( ! empty( $background_image ) ) {
				$styles[] = 'background-image: ' . $background_image_url;
			}

			return $styles;
		}

		public function add_additional_query_params( $params, $base ) {
			if ( 'warren_core_course_list' === $base ) {
				$params['instructor'] = esc_html__( 'Instructor Name', 'warren-core' );
			}

			return $params;
		}

		public function add_additional_query_fields( $group ) {
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'instructor',
					'title'      => esc_html__( 'Instructor ID', 'warren-core' ),
					'group'      => $group,
					'dependency' => array(
						'show' => array(
							'additional_params' => array(
								'values'        => 'instructor',
								'default_value' => '',
							),
						),
					),
				)
			);
		}

		public function additional_query( $args, $atts, $post_type ) {

			if ( $post_type === $this->get_post_type() ) {
				if ( ! empty( $atts['additional_params'] ) && 'instructor' === $atts['additional_params'] || ! empty( $atts['additional_instructor'] ) ) {

					if ( ! empty( $atts['instructor'] ) ) {

						$meta = array(
							'key'     => 'qodef_course_instructor',
							'value'   => $atts['instructor'],
							'compare' => '=',
						);

						if ( isset( $args['meta_query'] ) ) {
							$args['meta_query'] = array(
								'RELATION' => 'AND',
								$meta,
								$args['meta_query'],
							);
						} else {
							$args['meta_query'] = array( $meta );
						}
					}
				}

				if ( ! empty( $atts['price'] ) && 'all' !== $atts['price'] ) {
					if ( 'free' === $atts['price'] ) {
						$meta = array(
							'key'     => 'qodef_course_free',
							'value'   => array( 'yes' ),
							'compare' => 'IN',
						);
					} else {
						$meta = array(
							'key'     => 'qodef_course_free',
							'value'   => array( 'no' ),
							'compare' => 'IN',
						);
					}

					if ( isset( $args['meta_query'] ) ) {
						$args['meta_query'] = array(
							'RELATION' => 'AND',
							$meta,
							$args['meta_query'],
						);
					} else {
						$args['meta_query'] = array( $meta );
					}
				}
			}

			return $args;
		}

		public function add_additional_options( $group ) {
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_sorting',
					'title'         => esc_html__( 'Enable Sorting', 'warren-core' ),
					'description'   => esc_html__( 'Enabling this option will show sorting filter above list', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'no_yes' ),
					'default_value' => '',
					'dependency'    => array(
						'show' => array(
							'behavior' => array(
								'values'        => array( 'columns', 'masonry' ),
								'default_value' => 'columns',
							),
						),
					),
					'group'         => $group,
				)
			);
		}
	}
}
