<?php

$course_free           = get_post_meta( get_the_ID(), 'qodef_course_free', true );
$course_price          = get_post_meta( get_the_ID(), 'qodef_course_price', true );
$course_discount_price = get_post_meta( get_the_ID(), 'qodef_course_discount_price', true );

$currency_symbol       = '';
if ( qode_framework_is_installed( 'woocommerce' ) ) {
    global  $woocommerce;
    $currency_symbol = get_woocommerce_currency_symbol();
}

if ( 'yes' === $course_free ) {
	$course_price = esc_html__( 'Free', 'warren-core' );
}

if ( ! empty( $course_price ) ) { ?>
	<div class="qodef-e-price">
		<?php if ( ! empty( $course_discount_price ) ) { ?>
			<del class="qodef-e-old-price">
		<?php } ?>
		<?php
		if ( 'yes' === $course_free ) {
			echo '<span class="qodef-e-price-free">';
		}
		echo esc_attr( $course_price );
		if ( 'no' === $course_free ) {
			echo esc_html( $currency_symbol );
		}
		if ( 'yes' === $course_free ) {
			echo '</span>';
		}
		?>
		<?php if ( ! empty( $course_discount_price ) ) { ?>
			</del>
			<ins class="qodef-e-new-price">
				<?php echo esc_html( $course_discount_price ) . esc_html( $currency_symbol ); ?>
			</ins>
		<?php } ?>
	</div>
<?php } ?>
