<?php

$additional_info = get_post_meta( get_the_ID(), 'qodef_listing_single_additional_info_items', true );

if ( ! empty( $additional_info ) && is_array( $additional_info ) ) { ?>
	<div class="qodef-ls-additional-info">
		<?php warren_core_template_part( 'plugins/listing/post-types/listing', 'templates/parts/post-info/parts-title', '', array( 'title' => esc_html__( 'Additional info', 'warren-core' ) ) ); ?>
		<div class="qodef-ls-ai-items">
			<?php foreach ( $additional_info as $info ) { ?>
				<div class="qodef-ls-ai-item">
					<?php if ( isset( $info['qodef_listing_single_additional_info_title'] ) && ! empty( $info['qodef_listing_single_additional_info_title'] ) ) { ?>
						<p class="qodef-ls-ai-label"><?php echo esc_html( $info['qodef_listing_single_additional_info_title'] ); ?></p>
					<?php } ?>
					<?php
					if ( isset( $info['qodef_listing_single_additional_info_text'] ) && ! empty( $info['qodef_listing_single_additional_info_text'] ) ) {
						$value_have_link = isset( $info['qodef_listing_single_additional_info_link'] ) && ! empty( $info['qodef_listing_single_additional_info_link'] );
						?>
						<p class="qodef-ls-ai-value">
							<?php if ( $value_have_link ) { ?>
								<a itemprop="url" href="<?php echo esc_url( $info['qodef_listing_single_additional_info_link'] ); ?>">
							<?php } ?>
								<?php echo esc_html( $info['qodef_listing_single_additional_info_text'] ); ?>
							<?php if ( $value_have_link ) { ?>
								</a>
							<?php } ?>
						</p>
					<?php } ?>
				</div>
			<?php } ?>
		</div>
	</div>
<?php } ?>
