<?php

$instructor_id            = get_post_meta( get_the_ID(), 'qodef_course_instructor', true );
$user_meta                = get_userdata( $instructor_id );
$user_roles               = $user_meta ? $user_meta->roles : '';
$user_display_name        = $user_meta ? $user_meta->display_name : '';
$instructor_profile_image = '';

if ( is_array( $user_roles ) && in_array( 'instructor', $user_roles, true ) ) {
	$instructor_profile_image = get_user_meta( $instructor_id, 'qodef_instructor_profile_image', true );
}

if ( '' !== $instructor_profile_image ) {
	$profile_image = wp_get_attachment_image( $instructor_profile_image, 'medium' );
} else {
	$profile_image = get_avatar( $instructor_id, 96 );
}

?>
<div class="qodef-e-course-info qodef-e-info--instructor">
	<div class="qodef-e-instructor-image">
		<?php echo wp_kses_post( $profile_image ); ?>
	</div>
	<div class="qodef-e-instructor-info">
		<h6 class="qodef-e-title"><?php esc_html_e( 'Instructor ', 'warren-core' ); ?></h6>
		<a href="<?php echo get_author_posts_url( $instructor_id ); ?>" target="_blank"><?php echo esc_html( $user_display_name ); ?></a>
	</div>
</div>
