<?php

$lesson_id = ! empty( $qodef_course_subsection_item_lesson ) ? $qodef_course_subsection_item_lesson : 0;

if ( ! empty( $lesson_id ) ) {
	$lesson_title         = get_the_title( $lesson_id );
	$lesson_type          = get_post_meta( $lesson_id, 'qodef_lesson_type', true );
	$lesson_duration      = get_post_meta( $lesson_id, 'qodef_lesson_duration', true );
	$lesson_duration_unit = get_post_meta( $lesson_id, 'qodef_lesson_duration_unit', true );
	$lesson_free          = get_post_meta( $lesson_id, 'qodef_lesson_free', true );
	$duration_label       = warren_core_lms_get_duration_label( $lesson_duration, $lesson_duration_unit );
	$visible              = false;
	$preview_label        = false;

	switch ( $lesson_type ) {
		case 'reading':
			$icon_class   = 'qodef-e-lesson-icon fas fa-scroll';
			$type_label = esc_html__( 'Reading:', 'warren-core' );
			break;
		case 'audio':
			$icon_class   = 'qodef-e-lesson-icon fas fa-headphones-alt';
			$type_label = esc_html__( 'Audio:', 'warren-core' );
			break;
		case 'video':
			$icon_class   = 'qodef-e-lesson-icon fas fa-video';
			$type_label = esc_html__( 'Video:', 'warren-core' );
			break;
	}

	if ( 'yes' === $lesson_free || 'enrolled' === $status ) {
		$visible = true;
	}

	if ( 'yes' === $lesson_free && 'enrolled' !== $status ) {
		$preview_label = true;
	}
	?>
	<div class="qodef-e-lesson">
		<div class="qodef-e-title-holder">
			<span class="qodef-e-type-label"><?php echo esc_html( $type_label ); ?></span>
			<span class="qodef-e-lesson-title">
				<?php if ( $visible ) { ?>
					<a href="#" class="qodef-e-item-link" data-item-id="<?php echo esc_attr( $lesson_id ); ?>" data-item-type="<?php echo 'lesson'; ?>" data-course-id="<?php echo esc_attr( $course_id ); ?>">
					<?php
				}

				echo esc_html( $lesson_title );

				if ( $preview_label ) {
					?>
					<span class="qodef-e-preview"><?php esc_html_e( 'Preview', 'warren-core' ); ?></span>
					<?php
				}

				if ( $visible ) {
					?>
					</a>
				<?php } ?>
			</span>
		</div>
		<div class="qodef-e-lesson-duration">
			<?php echo esc_html( $lesson_duration . ' ' . $duration_label ); ?>
			<?php echo qode_framework_icons()->render_icon( 'qodef-e-duration-icon icon_clock_alt', 'elegant-icons' ); ?>
		</div>
	</div>
	<?php
}
?>
