<?php
$members             = get_post_meta( get_the_ID(), 'qodef_course_members_repeater', true );
$members_description = get_post_meta( get_the_ID(), 'qodef_course_members_description', true );

if ( empty( $members_description ) ) {
	$members_description = esc_html__( 'This is a list of members enrolled in this course', 'warren-core' );
}

?>
<div class="qodef-tab-content" id="qodef-tab-members">
	<div class="qodef-e-members-top">
		<h4 class="qodef-e-title">
			<?php esc_html_e( 'Members info', 'warren-core' ); ?>
		</h4>
		<p class="qodef-e-description">
			<?php echo esc_html( $members_description ); ?>
		</p>
	</div>
	<?php
	if ( is_array( $members ) && count( $members ) ) {
		$members_enrolled = array();

		foreach ( $members as $member ) {
			if ( 'enrolled' === $member['qodef_course_member_status'] ) {
				$members_enrolled[] = $member;
			}
		}

		if ( count( $members_enrolled ) ) {
			?>
			<div class="qodef-e-members-list-holder">
				<div class="qodef-e-top">
					<h6 class="qodef-e-members-title">
						<?php esc_html_e( 'Total number of students in course:', 'warren-core' ); ?>
					</h6>
					<div class="qodef-e-count">
						<?php echo count( $members_enrolled ); ?>
					</div>
				</div>
				<div class="qodef-e-members-list">
					<?php
					foreach ( $members_enrolled as $member ) {
						warren_core_template_part( 'plugins/lms/post-types/course', 'templates/parts/post-info/member-info', '', array( 'id' => $member['qodef_course_member_id'] ) );
					}
					?>
				</div>
			</div>
			<?php
		}
	}
	?>
</div>
