<?php

$course_free           = get_post_meta( get_the_ID(), 'qodef_course_free', true );
$course_price          = get_post_meta( get_the_ID(), 'qodef_course_price', true );
$course_discount_price = get_post_meta( get_the_ID(), 'qodef_course_discount_price', true );

$currency_symbol       = '';
if ( qode_framework_is_installed( 'woocommerce' ) ) {
    global  $woocommerce;
    $currency_symbol = get_woocommerce_currency_symbol();
}

if ( ! empty( $course_discount_price ) ) {
	$course_price = $course_discount_price;
}

if ( 'yes' === $course_free ) {
	$course_price = esc_html__( 'Free', 'warren-core' );
}

if ( ! empty( $course_price ) ) { ?>
	<span class="qodef-price">
		<?php echo esc_attr( $course_price ); ?><?php if ( 'no' === $course_free ) {
			echo esc_attr( $currency_symbol );
		} ?>
	</span>
<?php } ?>
