(function ( $ ) {
	'use strict';

	qodefCore.lesson = {};

	var qodefLesson = {
		init: function () {
			var $lesson = $( '.qodef-item-content.qodef--lesson' );

			if ( $lesson.length ) {
				qodefLesson.complete( $lesson );
			}
		},
		complete: function ( $lesson ) {
			var $button = $lesson.find( '.qodef-complete-lesson' );

			if ( $button.length ) {
				$button.on(
					'click',
					function ( e ) {
						e.preventDefault();

						var $this    = $( this );
						var ajaxData = {
							lesson_id: $this.data( 'lesson-id' ),
							course_id: $this.data( 'course-id' ),
						};

						$.ajax(
							{
								type: 'POST',
								url: qodefGlobal.vars.restUrl + qodefGlobal.vars.getLessonCompleteRestRoute,
								data: {
									options: ajaxData,
								},
								beforeSend: function ( request ) {
									request.setRequestHeader(
										'X-WP-Nonce',
										qodefGlobal.vars.restNonce
									);
								},
								success: function ( response ) {

									if ( response.status === 'success' ) {
										var $progress = $( '.qodef-course-single .qodef-e-above-info .qodef-progress-bar' );

										if ( $progress.length ) {
											$progress.data(
												'number',
												response.data.percentage
											);
											qodefCore.shortcodes.warren_core_progress_bar.qodefProgressBar.init();
										}

										$lesson.append( '<div class="qodef-e-completed">' + response.data.message + '</div>' );
										$this.hide();
									}
								},
								error: function ( response ) {
									console.log( response );
								}
							}
						);
					}
				);
			}
		},
	};

	qodefCore.lesson.qodefLesson = qodefLesson;

})( jQuery );
