<?php

if ( ! function_exists( 'warren_core_register_lesson_for_meta_options' ) ) {
	function warren_core_register_lesson_for_meta_options( $post_types ) {
		$post_types[] = 'lesson';

		return $post_types;
	}

	add_filter( 'qode_framework_filter_meta_box_save', 'warren_core_register_lesson_for_meta_options' );
	add_filter( 'qode_framework_filter_meta_box_remove', 'warren_core_register_lesson_for_meta_options' );
}

if ( ! function_exists( 'warren_core_add_lesson_custom_post_type' ) ) {
	/**
	 * Function that adds custom post type
	 *
	 * @param array $cpts
	 *
	 * @return array
	 */
	function warren_core_add_lesson_custom_post_type( $cpts ) {
		$cpts[] = 'WarrenCore_Lesson_CPT';

		return $cpts;
	}

	add_filter( 'warren_core_filter_register_custom_post_types', 'warren_core_add_lesson_custom_post_type' );
}

if ( class_exists( 'QodeFrameworkCustomPostType' ) ) {
	class WarrenCore_Lesson_CPT extends QodeFrameworkCustomPostType {

		public function map_post_type() {
			$name = esc_html__( 'Lesson', 'warren-core' );
			$this->set_base( 'lesson' );
			$this->set_menu_position( 5 );
			$this->set_menu_icon( 'dashicons-book' );
			$this->set_slug( 'lesson' );
			$this->set_name( $name );
			$this->set_path( WARREN_CORE_PLUGINS_PATH . '/lms/post-types/lesson' );
			$this->set_labels(
				array(
					'name'          => esc_html__( 'Warren Lesson', 'warren-core' ),
					'singular_name' => esc_html__( 'Lesson', 'warren-core' ),
					'add_item'      => esc_html__( 'New Lesson', 'warren-core' ),
					'add_new_item'  => esc_html__( 'Add New Lesson', 'warren-core' ),
					'edit_item'     => esc_html__( 'Edit Lesson', 'warren-core' ),
				)
			);

			$this->set_supports(
				array(
					'author',
					'title',
					'editor',
					'page-attributes',
				)
			);

			$this->set_public( false );
			$this->set_archive( false );
		}
	}
}
