<?php
$lesson_id        = isset( $item_id ) ? $item_id : get_the_ID();
$lesson_title     = get_the_title( $lesson_id );
$lesson_type      = get_post_meta( $lesson_id, 'qodef_lesson_type', true );
$lesson_completed = get_post_meta( $lesson_id, 'qodef_lesson_completed_message', true );
$lesson_status    = warren_core_get_item_status( $course_id, $lesson_id, 'lessons' );

if ( empty( $lesson_completed ) ) {
	$lesson_completed = esc_html__( 'Lesson completed!', 'warren-core' );
}

$button_params = array(
	'text'         => esc_html__( 'Complete', 'warren-core' ),
	'custom_class' => 'qodef-complete-lesson',
	'custom_attrs' => array(
		'data-lesson-id' => $lesson_id,
		'data-course-id' => $course_id,
	),
);
?>
<div class="qodef-item-content qodef--lesson">
	<h3 class="qodef-e-title">
		<?php echo esc_html( $lesson_title ); ?>
	</h3>
	<?php
	if ( in_array( $lesson_type, array( 'video', 'audio' ), true ) ) {
		// Get item syllabus part
		warren_core_template_part(
			'plugins/lms/post-types/lesson',
			'templates/parts/post-info/' . $lesson_type,
			'',
			array(
				'lesson_id'   => $lesson_id,
				'lesson_type' => $lesson_type,
			)
		);
	}
	?>
	<div class="qodef-e-content">
		<?php
		if ( qode_framework_is_installed( 'elementor' ) && warren_core_get_elementor_instance()->documents->get( $lesson_id )->is_built_with_elementor() ) {
			echo warren_core_get_elementor_instance()->frontend->get_builder_content( $lesson_id, true );
		} else {
			echo wp_kses_post( str_replace( ']]>', ']]&gt;', apply_filters( 'the_content', get_the_content( null, false, $lesson_id ) ) ) );
		}
		?>
	</div>
	<?php
	if ( 'to_start' === $lesson_status ) {
		echo WarrenCore_Button_Shortcode::call_shortcode( $button_params );
	} elseif ( 'completed' === $lesson_status ) {
		?>
		<div class="qodef-e-completed">
			<?php echo esc_html( $lesson_completed ); ?>
		</div>
	<?php } ?>
</div>
