<?php
$video_meta = get_post_meta( $lesson_id, 'qodef_lesson_video_url', true );

if ( ! empty( $video_meta ) ) {
	// Video player settings
	$settings = apply_filters(
		'warren_filter_video_post_format_settings',
		array(
			'width'  => 1100, // Aspect ratio is 16:9
			'height' => round( 1100 * 9 / 16 ),
			'loop'   => true,
		)
	);

	$oembed = wp_oembed_get( $video_meta );
	?>
	<div class="qodef-e-media">
	<?php
	if ( ! empty( $oembed ) ) {
		echo wp_oembed_get( $video_meta, $settings );
	} else {
		?>
		<div class="qodef-e-media-video">
			<?php
			// Init video player
			echo wp_video_shortcode( array_merge( array( 'src' => esc_url( $video_meta ) ), $settings ) );
			?>
		</div>
	<?php } ?>
	</div>
<?php } ?>
