(function ( $ ) {
	'use strict';

	qodefCore.question = {};

	var qodefQuestion = {
		init: function () {
			var $question = $( '.qodef-item-content.qodef--quiz .qodef-e-question' );

			if ( $question.length ) {
				var $actionHolder = $question.find( '.qodef-e-question-action' );
				var question_id   = $actionHolder.data( 'question-id' );

				qodefQuestion.hint(
					$question,
					$actionHolder,
					question_id
				);
				qodefQuestion.checkAnswer(
					$question,
					$actionHolder,
					question_id
				);
				qodefQuestion.nextQuestion(
					$question,
					$actionHolder,
					question_id
				);
			}
		},
		hint: function ( $question, $actionHolder, question_id ) {
			var $button = $actionHolder.find( '.qodef-question-hint' );

			if ( $button.length ) {
				$button.on(
					'click',
					function ( e ) {
						e.preventDefault();

						var $hintHolder = $question.find( '.qodef-e-question-hint' );

						var ajaxData = {
							question_id: question_id,
						};

						$.ajax(
							{
								type: 'GET',
								url: qodefGlobal.vars.restUrl + qodefGlobal.vars.getQuestionHintRestRoute,
								data: {
									options: ajaxData,
								},
								beforeSend: function ( request ) {
									request.setRequestHeader(
										'X-WP-Nonce',
										qodefGlobal.vars.restNonce
									);
								},
								success: function ( response ) {

									if ( response.status === 'success' ) {
										$hintHolder.html( response.data.hint );
										$button.addClass( 'qodef--disable' );
									}
								},
								error: function ( response ) {
									console.log( response );
								}
							}
						);
					}
				);
			}
		},
		checkAnswer: function ( $question, $actionHolder, question_id ) {
			var $button = $actionHolder.find( '.qodef-question-check' );

			if ( $button.length ) {
				$button.on(
					'click',
					function ( e ) {
						e.preventDefault();

						var $answers;
						var $answersHolder = $question.find( '.qodef-e-content-holder' );

						if ( $answersHolder.hasClass( 'qodef--choice' ) ) {
							$answers = $answersHolder.find( 'input' );
						} else {
							$answers = $answersHolder.find( 'textarea' );
						}

						var ajaxData = {
							question_id: question_id,
							quiz_id: $actionHolder.data( 'quiz-id' ),
							course_id: $actionHolder.data( 'course-id' ),
						};

						$.ajax(
							{
								type: 'POST',
								url: qodefGlobal.vars.restUrl + qodefGlobal.vars.getQuestionCheckAnswerRestRoute,
								data: {
									options: ajaxData,
								},
								beforeSend: function ( request ) {
									request.setRequestHeader(
										'X-WP-Nonce',
										qodefGlobal.vars.restNonce
									);
								},
								success: function ( response ) {

									if ( response.status === 'success' ) {
										$answers.each(
											function () {
												var $this = $( this );
												var value = $this.val().trim();

												if ( -1 === response.data.answer.indexOf( value ) ) {
													$this.addClass( 'qodef--false' );
													$this.parent( 'label' ).addClass( 'qodef--false' );

													if ( $this.hasClass( 'qodef-e-question-textarea' ) ) {
														$this.after( '<div class="qodef--correct">' + response.data.answer + '</div>' );
													}
												} else {
													$this.addClass( 'qodef--true' );
													$this.parent( 'label' ).addClass( 'qodef--true' );
												}
											}
										);

										$button.addClass( 'qodef--disable' );
									}
								},
								error: function ( response ) {
									console.log( response );
								}
							}
						);
					}
				);
			}
		},
		nextQuestion: function ( $question, $actionHolder, question_id ) {
			var $button = $actionHolder.find( '.qodef-question-next' );

			if ( $button.length ) {
				$button.each(
					function () {
						$( this ).on(
							'click',
							function ( e ) {
								e.preventDefault();

								var answers         = [],
									$thisButton     = $( this ),
									$questionHolder = $question.parents( '.qodef-e-content' ),
									$coursePopup    = $( '#qodef-course-popup' ),
									question        = 0,
									$answersHolder  = $question.find( '.qodef-e-content-holder' );

								if ( $answersHolder.hasClass( 'qodef--choice' ) ) {
									var $answers = $answersHolder.find( 'input:checked' );

									if ( $answers.length ) {
										$answers.each(
											function () {
												answers.push( $( this ).val() );
											}
										);
									}
								} else {
									answers.push( $answersHolder.find( 'textarea' ).val() );
								}

								if ( typeof $thisButton.data( 'question' ) !== 'undefined' ) {
									question = $thisButton.data( 'question' );
								}

								var ajaxData = {
									course_id: $thisButton.data( 'course-id' ),
									quiz_id: $thisButton.data( 'quiz-id' ),
									question_id: $thisButton.data( 'question-id' ),
									question: question,
									answers: answers.join( '()' ),
								};

								//if course popup already opened - then qodef--loading class is required for loading animation
								if ( qodef.body.hasClass( 'qodef-cp-opened' ) ) {
									$coursePopup.addClass( 'qodef--loading' );
								}

								$.ajax(
									{
										type: 'POST',
										url: qodefGlobal.vars.restUrl + qodefGlobal.vars.getQuestionNextRestRoute,
										data: {
											options: ajaxData,
										},
										beforeSend: function ( request ) {
											request.setRequestHeader(
												'X-WP-Nonce',
												qodefGlobal.vars.restNonce
											);
										},
										success: function ( response ) {

											if ( response.status === 'success' ) {

												$questionHolder.html( response.data.html );
												qodefQuestion.init();
												qodefCore.quiz.qodefQuiz.finish( $questionHolder.parents( '.qodef--quiz' ) );

												$coursePopup.removeClass( 'qodef--loading' );

												if ( typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
													$questionHolder.scrollTop( 0 );
													qodefCore.qodefPerfectScrollbar.init( $question );
												}
											}
										},
										error: function ( response ) {
											console.log( response );
										}
									}
								);
							}
						);
					}
				);
			}
		}
	};

	qodefCore.question.qodefQuestion = qodefQuestion;

})( jQuery );
