(function ( $ ) {
	'use strict';

	qodefCore.quiz = {};

	$( document ).on(
		'warren_core_trigger_course_close warren_core_trigger_before_get_content',
		function ( e, popUp ) {
			qodefQuiz.terminateTime( popUp );
		}
	);

	var qodefQuiz = {
		init: function () {
			var $quiz = $( '.qodef-item-content.qodef--quiz' );

			if ( $quiz.length ) {
				qodefQuiz.openQuiz( $quiz );
			}
		},
		openQuiz: function ( $quiz ) {
			var $trigger = $quiz.find( '.qodef-start-quiz' );

			if ( $trigger.length ) {
				$trigger.each(
					function () {
						$( this ).on(
							'click',
							function ( e ) {
								e.preventDefault();

								var $thisButton  = $( this ),
									$question    = $quiz.find( '.qodef-e-content' ),
									$coursePopup = $( '#qodef-course-popup' ),
									$timer       = $quiz.find( '.qodef-e-info-timer' ),
									durationAll  = $timer.data( 'time' ),
									duration     = parseInt( durationAll.substring( 0, durationAll.length - 1 ), 10 ),
									durationUnit = durationAll.substring( durationAll.length - 1 ),
									question     = 0;

								switch (durationUnit) {
									case 'm':
										duration *= 60;
										break;
									case 'h':
										duration *= 3600;
										break;
								}

								if ( typeof $thisButton.data( 'question' ) !== 'undefined' ) {
									question = $thisButton.data( 'question' );
								}

								//to reset timer properly if retake action is done immediately after finishing quiz
								if ( 'yes' === $thisButton.data( 'retake' ) ) {
									var $clone = $timer.clone();

									$timer.after( $clone );
									$timer.remove();

									$timer = $clone;
								}

								var ajaxData = {
									course_id: $thisButton.data( 'course-id' ),
									quiz_id: $thisButton.data( 'quiz-id' ),
									retake: $thisButton.data( 'retake' ),
									question: question,
								};

								//if course popup already opened - then qodef--loading class is required for loading animation
								if ( qodef.body.hasClass( 'qodef-cp-opened' ) ) {
									$coursePopup.addClass( 'qodef--loading' );
								}

								$.ajax(
									{
										type: 'POST',
										url: qodefGlobal.vars.restUrl + qodefGlobal.vars.getQuizQuestionRestRoute,
										data: {
											options: ajaxData,
										},
										beforeSend: function ( request ) {
											request.setRequestHeader(
												'X-WP-Nonce',
												qodefGlobal.vars.restNonce
											);
										},
										success: function ( response ) {

											if ( response.status === 'success' ) {

												$question.html( response.data.html );
												qodefCore.question.qodefQuestion.init();
												qodefQuiz.finish( $quiz );
												$coursePopup.removeClass( 'qodef--loading' );

												$timer.vTimer(
													'start',
													{ duration: duration }
												)
												.on(
													'update',
													function ( e, remaining ) {
														// total seconds
														var seconds = remaining;
														// calculate seconds
														var s = seconds % 60;
														// add leading zero to second if needed
														s = s < 10 ? '0' + s : s;
														// calculate minutes
														var m = Math.floor( seconds / 60 ) % 60;
														// add leading zero to minutes if needed
														m = m < 10 ? '0' + m : m;
														// calculate hours
														var h    = Math.floor( seconds / 60 / 60 );
														h        = h < 10 ? '0' + h : h;
														var time = h + ':' + m + ':' + s;
														$timer.text( time );
														$timer.data(
															'time',
															remaining
														);
													}
												)
												.on(
													'complete',
													function () {
														$quiz.find( '.qodef-quiz-finish' ).trigger( 'click' );
													}
												);

												if ( typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
													$question.scrollTop( 0 );
													qodefCore.qodefPerfectScrollbar.init( $question );
												}
											}
										},
										error: function ( response ) {
											console.log( response );
										}
									}
								);
							}
						);
					}
				);
			}
		},
		terminateTime: function ( popUp ) {
			if ( $( popUp ).length ) {
				var $quiz     = $( popUp ).find( '.qodef-item-content.qodef--quiz' ),
					$question = $quiz.find( '.qodef-e-question' );

				//question length is indicator that quiz has started, if started timer should be canceled
				if ( $quiz.length && $question.length ) {
					var $timer      = $quiz.find( '.qodef-e-info-timer' ),
						question_id = '',
						answers     = [];

					$timer.vTimer( 'cancel' );

					if ( $question.length ) {
						var $answersHolder  = $quiz.find( '.qodef-e-content-holder' ),
							$questionAction = $quiz.find( '.qodef-e-question-action' );

						if ( $answersHolder.hasClass( 'qodef--choice' ) ) {
							var $answers = $answersHolder.find( 'input:checked' );

							if ( $answers.length ) {
								$answers.each(
									function () {
										answers.push( $( this ).val() );
									}
								);
							}
						} else {
							answers.push( $answersHolder.find( 'textarea' ).val() );
						}

						question_id = $questionAction.data( 'question-id' );
					}

					var ajaxData = {
						quiz_id: $quiz.data( 'quiz-id' ),
						course_id: $quiz.data( 'course-id' ),
						time_left: $timer.data( 'time' ) + 's',
						question_id: question_id,
						answers: answers.join( '()' ),
					};

					$.ajax(
						{
							type: 'POST',
							url: qodefGlobal.vars.restUrl + qodefGlobal.vars.getQuizCanceledRestRoute,
							data: {
								options: ajaxData,
							},
							beforeSend: function ( request ) {
								request.setRequestHeader(
									'X-WP-Nonce',
									qodefGlobal.vars.restNonce
								);
							},
							success: function ( response ) {

								if ( response.status === 'success' ) {
									console.log( response );
								}
							},
							error: function ( response ) {
								console.log( response );
							}
						}
					);
				}
			}
		},
		finish: function ( $quiz ) {
			var $finish = $quiz.find( '.qodef-quiz-finish' );

			if ( $finish.length ) {
				$finish.on(
					'click',
					function ( e ) {
						e.preventDefault();

						var answers         = [],
							$content        = $quiz.find( '.qodef-e-content' ),
							$answersHolder  = $quiz.find( '.qodef-e-content-holder' ),
							$questionAction = $quiz.find( '.qodef-e-question-action' ),
							$courseSingle   = $( '.qodef-course-single' ),
							$courseAction   = $courseSingle.find( '.qodef-e-action-holder' );

						if ( $answersHolder.hasClass( 'qodef--choice' ) ) {
							var $answers = $answersHolder.find( 'input:checked' );

							if ( $answers.length ) {
								$answers.each(
									function () {
										answers.push( $( this ).val() );
									}
								);
							}
						} else {
							answers.push( $answersHolder.find( 'textarea' ).val() );
						}

						var ajaxData = {
							question_id: $questionAction.data( 'question-id' ),
							quiz_id: $quiz.data( 'quiz-id' ),
							course_id: $quiz.data( 'course-id' ),
							answers: answers.join( '()' ),
						};

						$.ajax(
							{
								type: 'POST',
								url: qodefGlobal.vars.restUrl + qodefGlobal.vars.getQuizFinishedRestRoute,
								data: {
									options: ajaxData,
								},
								beforeSend: function ( request ) {
									request.setRequestHeader(
										'X-WP-Nonce',
										qodefGlobal.vars.restNonce
									);
								},
								success: function ( response ) {

									if ( response.status === 'success' ) {
										var $timer = $quiz.find( '.qodef-e-info-timer' );

										if ( $courseAction.length ) {
											$courseAction.html( response.data.progress );

											//bind needed events
											qodefCore.shortcodes.warren_core_progress_bar.qodefProgressBar.init();
											qodefCore.course.qodefCourse.retakeCourse( $courseSingle );
										}

										if ( $timer.length ) {
											$timer.vTimer( 'cancel' );
											$timer.vTimer( 'stop' );
										}

										$content.html( response.data.html );
										$timer.attr(
											'data-time',
											response.data.time
										);
										$timer.data(
											'time',
											response.data.time
										);

										//to initiate retake button
										qodefQuiz.openQuiz( $quiz );
									}
								},
								error: function ( response ) {
									console.log( response );
								}
							}
						);
					}
				);
			}
		}
	};

	qodefCore.quiz.qodefQuiz = qodefQuiz;

})( jQuery );
