<?php
$quiz_id   = isset( $item_id ) ? $item_id : get_the_ID();
$questions = get_post_meta( $quiz_id, 'qodef_quiz_questions', true );

$current_question_id  = $questions[ $question ];
$question_type        = get_the_title( $current_question_id );
$question_type        = get_post_meta( $current_question_id, 'qodef_question_type', true );
$question_description = get_post_meta( $current_question_id, 'qodef_question_description', true );

$button_params = array(
	'text'         => esc_html__( 'Start Quiz', 'warren-core' ),
	'custom_class' => 'qodef-start-quiz',
	'custom_attrs' => array(
		'quiz-id'   => $quiz_id,
		'course-id' => $course_id,
		'question'  => $quiz_info['question'],
	),
);
?>
<div class="qodef-e-question">
	<h4 class="qodef-e-title">
		<?php echo esc_html( $quiz_title ); ?>
	</h4>
	<p class="qodef-e-description">
		<?php echo esc_html( $question_description ); ?>
	</p>
	<div class="qodef-e-content-holder">
		<?php
		warren_core_template_part(
			'plugins/lms/post-types/question',
			'templates/parts/post-info/' . $question_type,
			'',
			array(
				'question_id'   => $current_question_id,
				'question_type' => $question_type,
			)
		);
		?>
	</div>
</div>
