<?php
$quiz_title        = get_the_title( $quiz_id );
$questions_number  = count( get_post_meta( $quiz_id, 'qodef_quiz_questions', true ) );
$questions_label   = $questions_number . esc_html__( ' Questions', 'warren-core' );
$retakes           = get_post_meta( $quiz_id, 'qodef_quiz_retakes_number', true );
$completed_message = get_post_meta( $quiz_id, 'qodef_quiz_completed_message', true );
$quiz_message      = esc_html__( 'Quiz passed!', 'warren-core' );
$passing_percent   = intval( get_post_meta( $quiz_id, 'qodef_quiz_passing_percentage', true ) );
$percentage        = $points / $total_points * 100;

if ( 1 === $questions_number ) {
	$questions_label = $questions_number . esc_html__( ' Question', 'warren-core' );
}

if ( ! empty( $completed_message ) ) {
	$completed_message = esc_html__( 'Quiz Completed!', 'warren-core' );
}

if ( $percentage < $passing_percent ) {
	$quiz_message = esc_html__( 'Quiz failed.', 'warren-core' );
}

$button_params = array(
	// translators: %d - added retakes left number
	'text'         => sprintf( esc_html__( 'Retake Quiz +%d', 'warren-core' ), intval( $retakes ) - $takes + 1 ),
	'custom_class' => 'qodef-start-quiz',
	'custom_attrs' => array(
		'data-quiz-id'   => $quiz_id,
		'data-course-id' => $course_id,
		'data-question'  => 0,
		'data-retake'    => 'yes',
	),
);

?>
<div class="qodef-quiz-statistics">
	<div class="qodef-e-content">
		<div class="qodef-e-stat--completed"><?php echo esc_html( $completed_message ); ?></div>
		<div class="qodef-e-stat--points"><?php echo esc_html( $points . '/' . $total_points ) . esc_html__( ' points.', 'warren-core' ); ?></div>
		<div class="qodef-e-stat--correct"><?php echo esc_html( $correct ) . esc_html__( ' correct answers.', 'warren-core' ); ?></div>
		<div class="qodef-e-stat--incorrect"><?php echo esc_html( $incorrect ) . esc_html__( ' incorrect answers.', 'warren-core' ); ?></div>
		<div class="qodef-e-stat--status"><?php echo esc_html( $quiz_message ); ?></div>
		<?php
		if ( $takes > $retakes ) {
			esc_html_e( 'Sorry, you have exceeded retakes limit.', 'warren-core' );
		} else {
			echo WarrenCore_Button_Shortcode::call_shortcode( $button_params );
		}
		?>
	</div>
</div>
