<?php

if ( ! function_exists( 'warren_core_add_twitter_list_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function warren_core_add_twitter_list_widget( $widgets ) {
		if ( qode_framework_is_installed( 'twitter' ) ) {
			$widgets[] = 'WarrenCore_Twitter_List_Widget';
		}

		return $widgets;
	}

	add_filter( 'warren_core_filter_register_widgets', 'warren_core_add_twitter_list_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class WarrenCore_Twitter_List_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$this->set_widget_option(
				array(
					'name'       => 'widget_title',
					'field_type' => 'text',
					'title'      => esc_html__( 'Title', 'warren-core' ),
				)
			);
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'warren_core_twitter_list',
				)
			);
			if ( $widget_mapped ) {
				$this->set_base( 'warren_core_twitter_list' );
				$this->set_name( esc_html__( 'Warren Twitter List', 'warren-core' ) );
				$this->set_description( esc_html__( 'Add a twitter list element into widget areas', 'warren-core' ) );
			}
		}

		public function render( $atts ) {
			echo WarrenCore_Twitter_List_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
