<?php

if ( ! function_exists( 'warren_core_add_product_list_variation_info_below_custom' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function warren_core_add_product_list_variation_info_below_custom( $variations ) {
		$variations['info-below-custom'] = esc_html__( 'Info Below Custom', 'warren-core' );

		return $variations;
	}

	add_filter( 'warren_core_filter_product_list_layouts', 'warren_core_add_product_list_variation_info_below_custom' );
}

if ( ! function_exists( 'warren_core_register_shop_list_info_below_custom_actions' ) ) {
	/**
	 * Function that override product item layout for current variation type
	 */
	function warren_core_register_shop_list_info_below_custom_actions() {

		// IMPORTANT - THIS CODE NEED TO COPY/PASTE ALSO INTO THEME FOLDER MAIN WOOCOMMERCE FILE - set_default_layout method

		// Add additional tags around product list item
		add_action( 'woocommerce_before_shop_loop_item', 'warren_add_product_list_item_holder', 5 ); // permission 5 is set because woocommerce_template_loop_product_link_open hook is added on 10
		add_action( 'woocommerce_after_shop_loop_item', 'warren_add_product_list_item_holder_end', 30 ); // permission 30 is set because woocommerce_template_loop_add_to_cart hook is added on 10

		// Add additional tags around product list item image
		add_action( 'woocommerce_before_shop_loop_item_title', 'warren_add_product_list_item_media_holder', 5 ); // permission 5 is set because woocommerce_show_product_loop_sale_flash hook is added on 10
		add_action( 'woocommerce_before_shop_loop_item_title', 'warren_add_product_list_item_media_holder_end', 20 ); // permission 30 is set because woocommerce_template_loop_product_thumbnail hook is added on 10

		// Add additional tags around product list item image
		add_action( 'woocommerce_before_shop_loop_item_title', 'warren_add_product_list_item_media_image_holder', 6 ); // permission 5 is set because woocommerce_show_product_loop_sale_flash hook is added on 10
		add_action( 'woocommerce_before_shop_loop_item_title', 'warren_add_product_list_item_media_image_holder_end', 14 ); // permission 30 is set because woocommerce_template_loop_product_thumbnail hook is added on 10

		// Add additional tags around content inside product list item image
		add_action( 'woocommerce_before_shop_loop_item_title', 'warren_add_product_list_item_additional_image_holder', 15 ); // permission 15 is set because woocommerce_template_loop_product_thumbnail hook is added on 10
		add_action( 'woocommerce_before_shop_loop_item_title', 'warren_add_product_list_item_additional_image_holder_end', 17 ); // permission 25 is set because warren_add_product_list_item_media_holder_end hook is added on 30

		// Add link at the end of woocommerce_before_shop_loop_item_title
		add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_open', 17 ); // permission 28 is set because warren_add_product_list_item_media_holder_end is 30
		add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 18 ); // permission 29 is set because warren_add_product_list_item_media_holder_end is 30

		// Add additional tags around product list item content
		add_action( 'woocommerce_shop_loop_item_title', 'warren_add_product_list_item_content_holder', 5 ); // permission 5 is set because woocommerce_template_loop_product_title hook is added on 10
		add_action( 'woocommerce_after_shop_loop_item', 'warren_add_product_list_item_content_holder_end', 20 ); // permission 30 is set because woocommerce_template_loop_add_to_cart hook is added on 10

		// Add additional tags around categories
//		add_action( 'woocommerce_shop_loop_item_title', 'warren_add_product_list_item_top_and_info_holder', 7 ); // permission 5 is set because woocommerce_template_loop_product_title hook is added on 10
//		add_action( 'woocommerce_shop_loop_item_title', 'warren_add_product_list_item_categories', 8 ); // permission 8 is set to be before woocommerce_template_loop_product_title hook it's added on 10
//		add_action( 'woocommerce_shop_loop_item_title', 'warren_add_product_list_item_top_and_info_holder_end', 9 ); // permission 30 is set because woocommerce_template_loop_add_to_cart hook is added on 10

		// Change add to cart position on product list
		remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 ); // permission 10 is default
		add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_add_to_cart', 16 ); // permission 20 is set because warren_add_product_list_item_additional_image_holder hook is added on 15

		// remove product rating on list
		remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );

		// Add product tagline on list
		add_action( 'woocommerce_shop_loop_item_title', 'warren_add_product_list_item_tagline', 11 ); // permission 11 is set to be after woocommerce_template_loop_product_title hook it's added on 10
	}

	add_action( 'warren_core_action_shop_list_item_layout_info-below-custom', 'warren_core_register_shop_list_info_below_custom_actions' );
}

if ( ! function_exists( 'warren_core_add_product_list_variation_info_below_custom_options' ) ) {
	/**
	 * Function that add additional options for variation layout
	 *
	 * @param array $options
	 *
	 * @return array
	 */
	function warren_core_add_product_list_variation_info_below_custom_options( $options ) {
		$custom_options            = array();
		$custom_options_dependency = array(
			'show' => array(
				'layout' => array(
					'values'        => 'info-below-custom',
					'default_value' => '',
				),
			),
		);

		$standard_horizontal_position = array(
			'field_type' => 'select',
			'name'       => 'enable_image_shadow',
			'title'      => esc_html__( 'Enable Image Shadow', 'warren-core' ),
			'options'    => warren_core_get_select_type_options_pool( 'no_yes', false ),
			'dependency' => $custom_options_dependency,
			'group'      => esc_html__( 'Layout', 'warren-core' ),
		);
		$custom_options[] = $standard_horizontal_position;

		return array_merge( $options, $custom_options );
	}

	add_filter( 'warren_core_filter_product_list_extra_options', 'warren_core_add_product_list_variation_info_below_custom_options' );
}
