<?php

if ( ! function_exists( 'warren_core_add_woo_side_area_cart_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function warren_core_add_woo_side_area_cart_widget( $widgets ) {
		$widgets[] = 'WarrenCore_WooCommerce_Side_Area_Cart_Widget';

		return $widgets;
	}

	add_filter( 'warren_core_filter_register_widgets', 'warren_core_add_woo_side_area_cart_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class WarrenCore_WooCommerce_Side_Area_Cart_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$this->set_base( 'warren_core_woo_side_area_cart' );
			$this->set_name( esc_html__( 'Warren WooCommerce Side Area Cart', 'warren-core' ) );
			$this->set_description( esc_html__( 'Display a shop cart icon with that shows products count that are in the cart', 'warren-core' ) );
		}

		public function load_assets() {
			wp_enqueue_style( 'perfect-scrollbar', WARREN_CORE_URL_PATH . 'assets/plugins/perfect-scrollbar/perfect-scrollbar.css', array() );
			wp_enqueue_script( 'perfect-scrollbar', WARREN_CORE_URL_PATH . 'assets/plugins/perfect-scrollbar/perfect-scrollbar.jquery.min.js', array( 'jquery' ), false, true );
		}

		public function widget( $args, $instance ) {
			// Prevent widgets from loading on WooCommerce cart page
			if ( qode_framework_is_installed( 'theme' ) && warren_is_woo_page( 'cart' ) ) {
				return;
			}

			parent::widget( $args, $instance );
		}

		public function render( $atts ) {
			?>
			<div class="qodef-widget-side-area-cart-inner">
				<?php warren_core_template_part( 'plugins/woocommerce/widgets/side-area-cart', 'templates/parts/opener' ); ?>
				<?php warren_core_template_part( 'plugins/woocommerce/widgets/side-area-cart', 'templates/content' ); ?>
			</div>
			<?php
		}
	}
}

if ( ! function_exists( 'warren_core_woo_side_area_cart_add_to_cart_fragment' ) ) {
	/**
	 * Function that return|update new cart content for products which are added into the cart
	 *
	 * @param array $fragments
	 *
	 * @return array
	 */
	function warren_core_woo_side_area_cart_add_to_cart_fragment( $fragments ) {
		ob_start();
		?>
		<div class="qodef-widget-side-area-cart-inner">
			<?php warren_core_template_part( 'plugins/woocommerce/widgets/side-area-cart', 'templates/parts/opener' ); ?>
			<?php warren_core_template_part( 'plugins/woocommerce/widgets/side-area-cart', 'templates/content' ); ?>
		</div>
		<?php
		$fragments['.qodef-widget-side-area-cart-inner'] = ob_get_clean();

		return $fragments;
	}

	add_filter( 'woocommerce_add_to_cart_fragments', 'warren_core_woo_side_area_cart_add_to_cart_fragment' );
}
