<?php

if ( ! function_exists( 'warren_core_add_events_single_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_events_single_meta_box() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'event-item' ),
				'type'  => 'meta',
				'slug'  => 'event-item',
				'title' => esc_html__( 'Event Item', 'warren-core' ),
			)
		);

		if ( $page ) {

			/* General sections */

			$general_section = $page->add_section_element(
				array(
					'name'        => 'qodef_event_single_general_section',
					'title'       => esc_html__( 'General Settings', 'warren-core' ),
					'description' => esc_html__( 'General information about event single', 'warren-core' ),
				)
			);

			$general_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_event_single_tickets_status',
					'title'       => esc_html__( 'Tickets Status', 'warren-core' ),
					'description' => esc_html__( 'Choose a tickets status for event single', 'warren-core' ),
					'options'     => array(
						'available' => esc_html__( 'Available', 'warren-core' ),
						'free'      => esc_html__( 'Free', 'warren-core' ),
						'sold'      => esc_html__( 'Sold', 'warren-core' ),
					),
				)
			);
			 $general_section->add_field_element(
                array(
                    'field_type' => 'text',
                    'name' => 'qodef_event_single_price',
                    'title' => esc_html__('Event Price', 'warren-core'),
                )
            );

			$general_section->add_field_element(
				array(
					'field_type'  => 'date',
					'name'        => 'qodef_event_single_start_date',
					'title'       => esc_html__( 'Event Start Date', 'warren-core' ),
					'description' => esc_html__( 'Enter event date', 'warren-core' ),
				)
			);

			$general_section->add_field_element(
				array(
					'field_type'  => 'date',
					'name'        => 'qodef_event_single_end_date',
					'title'       => esc_html__( 'Event End Date', 'warren-core' ),
					'description' => esc_html__( 'Enter event date', 'warren-core' ),
				)
			);

			$general_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_event_single_time',
					'title'       => esc_html__( 'Event Time', 'warren-core' ),
					'description' => esc_html__( 'Enter the time in a HH:MM format. If you are using a 12 hour time format, please also enter AM or PM markers', 'warren-core' ),
				)
			);

			$general_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_event_single_location',
					'title'       => esc_html__( 'Event Location', 'warren-core' ),
					'description' => esc_html__( 'Enter the event location. For example "Dolby Soho, Broadway New York"', 'warren-core' ),
				)
			);

			$general_section->add_field_element(
                array(
                    'field_type' => 'text',
                    'name' => 'qodef_event_single_specific_location',
                    'title' => esc_html__('Event Specific Location', 'warren-core'),
                    'description' => esc_html__('Enter the event specific location. For example "Harvard Education"', 'warren-core'),
                )
            );

			$general_section->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_event_single_website',
					'title'      => esc_html__( 'Event Website', 'warren-core' ),
				)
			);

			$general_section->add_field_element(
                array(
                    'field_type' => 'text',
                    'name' => 'qodef_event_single_email',
                    'title' => esc_html__('Event Email', 'warren-core'),
                )
            );

			$general_section->add_field_element(
                array(
                    'field_type' => 'text',
                    'name' => 'qodef_event_single_phone',
                    'title' => esc_html__('Event Phone', 'warren-core'),
                )
            );

			$general_section->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_event_single_organized_by',
					'title'      => esc_html__( 'Organized By', 'warren-core' ),
				)
			);

			$general_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_event_single_tickets_link',
					'title'       => esc_html__( 'Buy Tickets Link', 'warren-core' ),
					'description' => esc_html__( 'Enter the external link where users can buy the tickets', 'warren-core' ),
				)
			);

			$general_section->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_event_single_tickets_link_text',
					'title'      => esc_html__( 'Tickets Link Text', 'warren-core' ),
				)
			);

			$general_section->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_event_single_tickets_link_target',
					'title'      => esc_html__( 'Tickets Link Target', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'link_target' ),
				)
			);
			$general_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_event_list_image',
					'title'       => esc_html__( 'Event List Image', 'warren-core' ),
					'description' => esc_html__( 'Upload image to be displayed on event list instead of featured image', 'warren-core' ),
				)
			);

			$general_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_masonry_image_dimension_event_item',
					'title'       => esc_html__( 'Image Dimension', 'warren-core' ),
					'description' => esc_html__( 'Choose an image layout for "masonry behavior" event list. If you are using fixed image proportions on the list, choose an option other than default', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'masonry_image_dimension' ),
				)
			);

			/* Social sections */

			$social_section = $page->add_section_element(
				array(
					'name'        => 'qodef_event_single_social_section',
					'title'       => esc_html__( 'Social Settings', 'warren-core' ),
					'description' => esc_html__( 'Social information about event single.', 'warren-core' ),
				)
			);

			$social_icons_repeater = $social_section->add_repeater_element(
				array(
					'name'        => 'qodef_events_single_social_icons',
					'title'       => esc_html__( 'Social Networks', 'warren-core' ),
					'description' => esc_html__( 'Populate events single social networks info', 'warren-core' ),
					'button_text' => esc_html__( 'Add New Network', 'warren-core' ),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_events_single_icon_source',
					'title'         => esc_html__( 'Team Member Icon Source', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'icon_source', false, array( 'predefined' ) ),
					'default_value' => 'svg_path',
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'iconpack',
					'name'       => 'qodef_events_single_icon',
					'title'      => esc_html__( 'Icon', 'warren-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_events_single_icon_source' => array(
								'values'        => 'icon_pack',
								'default_value' => 'svg_path',
							),
						),
					),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_events_single_svg_path',
					'title'       => esc_html__( 'Events Single Icon SVG Path', 'warren-core' ),
					'description' => esc_html__( 'Enter your search open icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'warren-core' ),
					'dependency'  => array(
						'show' => array(
							'qodef_events_single_icon_source' => array(
								'values'        => 'svg_path',
								'default_value' => 'svg_path',
							),
						),
					),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_events_single_icon_link',
					'title'      => esc_html__( 'Icon Link', 'warren-core' ),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_events_single_icon_target',
					'title'      => esc_html__( 'Icon Target', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'link_target' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_events_single_meta_box_map', $page );
		}
	}

	add_action( 'warren_core_action_default_meta_boxes_init', 'warren_core_add_events_single_meta_box' );
}
