(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.warren_core_podcast_player = {};

	$( document ).ready(
		function () {
			qodefPodcastPlayer.init();
		}
	);

	var qodefPodcastPlayer = {
		init: function () {
			this.holder = $( '.qodef-podcast-player' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {

						var $thisItem        = $( this ),
							$thisHolderAudio = $thisItem.find( 'audio' ),
							$jumpButton      = $( '.qodef-jump-button' ),
							player           = $thisHolderAudio[0];

						$jumpButton.on(
							'click',
							function ( e ) {
								e.preventDefault();
								var $thisJumpLink = $( this ),
									$thisJumpButton = $( this ).find('.mejs-button');

								if ( ! $thisJumpButton.hasClass( 'mejs-pause' ) ) {
									var $timeString  = $thisJumpLink.data( 'chapter-time' ),
										p            = $timeString.split( ':' ),
										$time = 0, m = 1;

									while (p.length > 0) {
										$time += m * parseInt(
											p.pop(),
											10
										);
										m *= 60;
									}
									player.setCurrentTime( $time );
									player.play();

									$('.qodef-podcast-sections').find('.mejs-button').removeClass( 'mejs-play' );
									$('.qodef-podcast-sections').find('.mejs-button').removeClass( 'mejs-pause' );
									$thisJumpButton.addClass( 'mejs-pause' );
								} else {
									player.pause();
									$('.qodef-podcast-sections-top').find('.mejs-button').removeClass( 'mejs-pause' );
								}
							}
						);
					}
				);
			}

		},
	};

})( jQuery );

