<?php

if ( ! function_exists( 'warren_core_add_podcast_item_list_meta_boxes' ) ) {
	/**
	 * Function that add general meta box options for this module
	 *
	 * @param object $page
	 */
	function warren_core_add_podcast_item_list_meta_boxes( $page ) {

		if ( $page ) {

			$list_tab = $page->add_tab_element(
				array(
					'name'        => 'tab-list',
					'icon'        => 'fa fa-cog',
					'title'       => esc_html__( 'List Settings', 'warren-core' ),
					'description' => esc_html__( 'Podcast list settings', 'warren-core' )
				)
			);

			$list_tab->add_field_element( array(
				'field_type'  => 'image',
				'name'        => 'qodef_podcast_list_image',
				'title'       => esc_html__( 'Podcast List Image', 'warren-core' ),
				'description' => esc_html__( 'Upload image to be displayed on podcast list instead of featured image', 'warren-core' ),
			) );
			
			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_podcast_list_meta_box_map', $list_tab );
		}
	}

	add_action( 'warren_core_action_after_podcast_meta_box_map', 'warren_core_add_podcast_item_list_meta_boxes' );
}