<?php
$podcast_sections_items = get_post_meta( get_the_ID(), 'qodef_podcast_parts_items', true );
$podcast_sections_image = get_post_meta( get_the_ID(), 'qodef_podcast_parts_image', true );
?>

<?php if ( ! empty ( $podcast_sections_items ) && ! empty ( $podcast_sections_image ) ) { ?>

	<div class="qodef-podcast-sections">

		<div class="qodef-podcast-sections-top qodef-e-content qodef-content-grid">
			<?php if ( ! empty ( $podcast_sections_items ) ) { ?>
				<h5 class="qodef-e qodef-info--title">
					<?php esc_html_e( 'Listen to the specific part', 'warren-core' ); ?>
				</h5>
				<div class="qodef-m-items">


					<?php foreach ( $podcast_sections_items as $item ) {
						$label = $item['qodef_part_item_label'];
						$value = $item['qodef_part_item_value'];
						$link  = '#' . $value;
						?>
						<div class="qodef-e qodef-info-items">
							<a class="qodef-jump-button" href="<?php echo esc_html( $link ); ?>"
							   data-chapter-time="<?php echo esc_attr( $value ); ?>">
								<div class="mejs-button mejs-playpause-button mejs-play">
									<div class="qodef-mejs-button-filter"></div>
								</div>
							</a>
							<div class="qodef-e-content">
								<span class="qodef-e-time"><?php echo qode_framework_wp_kses_html( 'content', $value ); ?></span>
								<?php if ( ! empty ( $label ) ) { ?>
									<h6 class="qodef-e-title"><?php echo esc_html( $label ); ?></h6>
								<?php } ?>
							</div>
						</div>
					<?php } ?>
				</div>
			<?php } ?>
		</div>
		<div class="qodef-podcast-sections-bottom">
			<?php if ( ! empty ( $podcast_sections_image ) ) { ?>
				<div class="qodef-m-image">
					<?php echo wp_get_attachment_image( $podcast_sections_image, 'full', '', array( 'class' => 'qodef-parallax-no-opacity' ) ); ?>
				</div>
			<?php } ?>
			<div class="qodef-m-podcast-author">
				<?php warren_core_template_part( 'post-types/podcast', 'templates/single/single-author/templates/single-author' ); ?>
			</div>
		</div>


	</div>
<?php } ?>
