<?php
$is_enabled = warren_core_get_post_value_through_levels( 'qodef_podcast_enable_navigation' );

if ( 'yes' === $is_enabled ) {
	$through_same_category = 'yes' === warren_core_get_post_value_through_levels( 'qodef_podcast_navigation_through_same_category' );
	?>
	<div id="qodef-single-post-navigation" class="qodef-single-podcast-navigation qodef-content-grid">
		<div class="qodef-m-inner qodef-content-grid">
			<?php
			$post_navigation = array(
				'prev' => array(
					'label' => '<span class="qodef-m-nav-label">' . esc_html__( 'Previous', 'warren-core' ) . '</span>',
					'icon'  => warren_core_get_svg_icon( 'pagination-post-arrow-left', 'qodef-m-pagination-icon' ),
				),
				'next' => array(
					'label' => '<span class="qodef-m-nav-label">' . esc_html__( 'Next', 'warren-core' ) . '</span>',
					'icon'  => warren_core_get_svg_icon( 'pagination-post-arrow-right', 'qodef-m-pagination-icon' ),
				),
			);

			if ( $through_same_category ) {
				if ( '' !== get_previous_post( true ) ) {
					$post_navigation['prev']['post'] = get_previous_post( true );
				}
				if ( '' !== get_next_post( true ) ) {
					$post_navigation['next']['post'] = get_next_post( true );
				}
			} else {
				if ( '' !== get_previous_post() ) {
					$post_navigation['prev']['post'] = get_previous_post();
				}
				if ( '' !== get_next_post() ) {
					$post_navigation['next']['post'] = get_next_post();
				}
			}

			foreach ( $post_navigation as $key => $value ) {
				if ( isset( $post_navigation[ $key ]['post'] ) ) {
					$current_post = $value['post'];
					$post_id      = $current_post->ID;
					?>
					<a itemprop="url" class="qodef-m-nav qodef--<?php echo esc_attr( $key ); ?>"
					   href="<?php echo get_permalink( $post_id ); ?>">
						<span class="qodef-m-nav-info-top">
							<span class="qodef-m-nav-title">
								<?php echo get_the_title( $post_id ); ?>
							</span>
						</span>
						<span class="qodef-m-nav-info-bottom">
						<?php echo qode_framework_wp_kses_html( 'svg', $value['icon'] ); ?>
						<?php echo wp_kses( $value['label'], array( 'span' => array( 'class' => true ) ) ); ?>
								</span>
					</a>
					<?php
				}
			}
			?>
		</div>
	</div>
<?php } ?>
