<?php

if ( ! function_exists( 'warren_core_add_portfolio_archive_list_options' ) ) {
	/**
	 * Function that add list options for portfolio archive module
	 */
	function warren_core_add_portfolio_archive_list_options( $tab ) {
		$list_item_layouts = apply_filters( 'warren_core_filter_portfolio_list_layouts', array() );
		$options_map       = warren_core_get_variations_options_map( $list_item_layouts );

		if ( $tab ) {
			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_archive_item_layout',
					'title'         => esc_html__( 'Item Layout', 'warren-core' ),
					'description'   => esc_html__( 'Choose layout for list item on archive lists', 'warren-core' ),
					'options'       => $list_item_layouts,
					'default_value' => $options_map['default_value'],
				)
			);

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_archive_behavior',
					'title'       => esc_html__( 'List Appearance', 'warren-core' ),
					'description' => esc_html__( 'Choose an appearance style for archive lists', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'list_behavior' ),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_archive_masonry_images_proportion',
					'title'       => esc_html__( 'Masonry Image Proportions', 'warren-core' ),
					'description' => esc_html__( 'Choose image proportions for archive lists', 'warren-core' ),
					'options'     => array(
						''      => esc_html__( 'Original', 'warren-core' ),
						'fixed' => esc_html__( 'Fixed', 'warren-core' ),
					),
					'dependency'  => array(
						'show' => array(
							'qodef_portfolio_archive_behavior' => array(
								'values'        => 'masonry',
								'default_value' => 'columns',
							),
						),
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_archive_columns',
					'title'       => esc_html__( 'Number of Columns', 'warren-core' ),
					'description' => esc_html__( 'Choose number of columns for archive lists', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'columns_number' ),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_archive_space',
					'title'       => esc_html__( 'Items Horizontal Spacing', 'warren-core' ),
					'description' => esc_html__( 'Choose horizontal space between items for archive lists', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'items_space' ),
				)
			);

			$portfolio_archive_space_row = $tab->add_row_element(
				array(
					'name'       => 'qodef_portfolio_archive_space_row',
					'dependency' => array(
						'show' => array(
							'qodef_portfolio_archive_space' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$portfolio_archive_space_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_space_custom',
					'title'       => esc_html__( 'Custom Horizontal Spacing', 'warren-core' ),
					'description' => esc_html__( 'Enter horizontal space between items in pixels', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_archive_space_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_space_custom_1512',
					'title'       => esc_html__( 'Custom Horizontal Spacing - 1512', 'warren-core' ),
					'description' => esc_html__( 'Enter horizontal space between items in pixels below 1512px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_archive_space_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_space_custom_1200',
					'title'       => esc_html__( 'Custom Horizontal Spacing - 1200', 'warren-core' ),
					'description' => esc_html__( 'Enter horizontal space between items in pixels below 1200px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_archive_space_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_space_custom_880',
					'title'       => esc_html__( 'Custom Horizontal Spacing - 880', 'warren-core' ),
					'description' => esc_html__( 'Enter horizontal space between items in pixels below 880px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_archive_vertical_space',
					'title'       => esc_html__( 'Items Vertical Spacing', 'warren-core' ),
					'description' => esc_html__( 'Choose vertical space between items for archive lists', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'items_space' ),
				)
			);

			$portfolio_archive_vertical_space_row = $tab->add_row_element(
				array(
					'name'       => 'qodef_portfolio_archive_vertical_space_row',
					'dependency' => array(
						'show' => array(
							'qodef_portfolio_archive_vertical_space' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$portfolio_archive_vertical_space_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_vertical_space_custom',
					'title'       => esc_html__( 'Custom Vertical Spacing', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_archive_vertical_space_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_vertical_space_custom_1512',
					'title'       => esc_html__( 'Custom Vertical Spacing - 1512', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 1512px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_archive_vertical_space_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_vertical_space_custom_1200',
					'title'       => esc_html__( 'Custom Vertical Spacing - 1200', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 1200px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_archive_vertical_space_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_vertical_space_custom_880',
					'title'       => esc_html__( 'Custom Vertical Spacing - 880', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 880px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_archive_columns_responsive',
					'title'       => esc_html__( 'Columns Responsive', 'warren-core' ),
					'description' => esc_html__( 'Choose whether you wish to use predefined column number responsive settings, or to set column numbers for each responsive stage individually', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'columns_responsive' ),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_archive_columns_1512',
					'title'         => esc_html__( 'Number of Columns 1369px - 1512px', 'warren-core' ),
					'description'   => esc_html__( 'Choose number of columns for screens between 1369 and 1512 px for archive lists', 'warren-core' ),
					'default_value' => '3',
					'options'       => warren_core_get_select_type_options_pool( 'columns_number' ),
					'dependency'    => array(
						'show' => array(
							'qodef_portfolio_archive_columns_responsive' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_archive_columns_1368',
					'title'         => esc_html__( 'Number of Columns 1201px - 1368px', 'warren-core' ),
					'description'   => esc_html__( 'Choose number of columns for screens between 1201 and 1368 px for archive lists', 'warren-core' ),
					'default_value' => '3',
					'options'       => warren_core_get_select_type_options_pool( 'columns_number' ),
					'dependency'    => array(
						'show' => array(
							'qodef_portfolio_archive_columns_responsive' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_archive_columns_1200',
					'title'         => esc_html__( 'Number of Columns 1025px - 1200px', 'warren-core' ),
					'description'   => esc_html__( 'Choose number of columns for screens between 1025 and 1200 px for archive lists', 'warren-core' ),
					'default_value' => '3',
					'options'       => warren_core_get_select_type_options_pool( 'columns_number' ),
					'dependency'    => array(
						'show' => array(
							'qodef_portfolio_archive_columns_responsive' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_archive_columns_1024',
					'title'         => esc_html__( 'Number of Columns 881px - 1024px', 'warren-core' ),
					'description'   => esc_html__( 'Choose number of columns for screens between 881 and 1024 px for archive lists', 'warren-core' ),
					'default_value' => '3',
					'options'       => warren_core_get_select_type_options_pool( 'columns_number' ),
					'dependency'    => array(
						'show' => array(
							'qodef_portfolio_archive_columns_responsive' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_archive_columns_880',
					'title'         => esc_html__( 'Number of Columns 681px - 880px', 'warren-core' ),
					'description'   => esc_html__( 'Choose number of columns for screens between 681 and 880 px for archive lists', 'warren-core' ),
					'default_value' => '3',
					'options'       => warren_core_get_select_type_options_pool( 'columns_number' ),
					'dependency'    => array(
						'show' => array(
							'qodef_portfolio_archive_columns_responsive' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_archive_columns_680',
					'title'         => esc_html__( 'Number of Columns 0 - 680px', 'warren-core' ),
					'description'   => esc_html__( 'Choose number of columns for screens between 0 and 680 px for archive lists', 'warren-core' ),
					'default_value' => '3',
					'options'       => warren_core_get_select_type_options_pool( 'columns_number' ),
					'dependency'    => array(
						'show' => array(
							'qodef_portfolio_archive_columns_responsive' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_archive_slider_loop',
					'title'       => esc_html__( 'Enable Slider Loop', 'warren-core' ),
					'description' => esc_html__( 'Enable loop for slider display of archive lists', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'yes_no' ),
					'dependency'  => array(
						'show' => array(
							'qodef_portfolio_archive_behavior' => array(
								'values'        => 'slider',
								'default_value' => '',
							),
						),
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_archive_slider_autoplay',
					'title'       => esc_html__( 'Enable Slider Autoplay', 'warren-core' ),
					'description' => esc_html__( 'Enable autoplay for slider display of archive lists', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'yes_no' ),
					'dependency'  => array(
						'show' => array(
							'qodef_portfolio_archive_behavior' => array(
								'values'        => 'slider',
								'default_value' => '',
							),
						),
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_slider_speed',
					'title'       => esc_html__( 'Slider Speed', 'warren-core' ),
					'description' => esc_html__( 'Enter slider speed for slider display of archive lists', 'warren-core' ),
					'dependency'  => array(
						'show' => array(
							'qodef_portfolio_archive_behavior' => array(
								'values'        => 'slider',
								'default_value' => '',
							),
						),
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_archive_slider_navigation',
					'title'         => esc_html__( 'Enable Slider Navigation', 'warren-core' ),
					'description'   => esc_html__( 'Enable navigation for slider display of archive lists', 'warren-core' ),
					'default_value' => '3',
					'options'       => warren_core_get_select_type_options_pool( 'yes_no' ),
					'dependency'    => array(
						'show' => array(
							'qodef_portfolio_archive_behavior' => array(
								'values'        => 'slider',
								'default_value' => '',
							),
						),
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_archive_slider_pagination',
					'title'         => esc_html__( 'Enable Slider Pagination', 'warren-core' ),
					'description'   => esc_html__( 'Enable pagination for slider display of archive lists', 'warren-core' ),
					'default_value' => '3',
					'options'       => warren_core_get_select_type_options_pool( 'yes_no' ),
					'dependency'    => array(
						'show' => array(
							'qodef_portfolio_archive_behavior' => array(
								'values'        => 'slider',
								'default_value' => '',
							),
						),
					),
				)
			);

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_archive_pagination_type',
					'title'       => esc_html__( 'Pagination', 'warren-core' ),
					'description' => esc_html__( 'Choose pagination type for archive lists', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'pagination_type' ),
					'dependency'  => array(
						'hide' => array(
							'qodef_portfolio_archive_behavior' => array(
								'values'        => 'slider',
								'default_value' => '',
							),
						),
					),
				)
			);
		}
	}

	add_action( 'warren_core_action_after_portfolio_options_archive', 'warren_core_add_portfolio_archive_list_options' );
}
