<?php

if ( ! function_exists( 'warren_core_add_portfolio_single_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_portfolio_single_meta_box() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'  => array( 'portfolio-item' ),
				'type'   => 'meta',
				'slug'   => 'portfolio-item',
				'title'  => esc_html__( 'Portfolio Settings', 'warren-core' ),
				'layout' => 'tabbed',
			)
		);

		if ( $page ) {

			$general_tab = $page->add_tab_element(
				array(
					'name'        => 'tab-general',
					'icon'        => 'fa fa-cog',
					'title'       => esc_html__( 'General Settings', 'warren-core' ),
					'description' => esc_html__( 'General portfolio settings', 'warren-core' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_single_layout',
					'title'       => esc_html__( 'Single Layout', 'warren-core' ),
					'description' => esc_html__( 'Choose default layout for portfolio single', 'warren-core' ),
					'options'     => apply_filters( 'warren_core_filter_portfolio_single_layout_options', array( '' => esc_html__( 'Default', 'warren-core' ) ) ),
				)
			);

			$section_columns = $general_tab->add_section_element(
				array(
					'name'       => 'qodef_portfolio_columns_section',
					'dependency' => array(
						'show' => array(
							'qodef_portfolio_single_layout' => array(
								'values'        => array(
									'masonry-big',
									'masonry-small',
									'gallery-big',
									'gallery-small',
								),
								'default_value' => '',
							),
						),
					),
				)
			);

			$section_columns->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_portfolio_columns_number',
					'title'      => esc_html__( 'Number of Columns', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'columns_number' ),
				)
			);

			$section_columns->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_portfolio_space_between_items',
					'title'      => esc_html__( 'Items Horizontal Spacing', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'items_space' ),
				)
			);

			$portfolio_space_between_items_row = $section_columns->add_row_element(
				array(
					'name'       => 'qodef_portfolio_space_between_items_row',
					'dependency' => array(
						'show' => array(
							'qodef_portfolio_space_between_items' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$portfolio_space_between_items_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_space_between_items_custom',
					'title'       => esc_html__( 'Custom Horizontal Spacing', 'warren-core' ),
					'description' => esc_html__( 'Enter horizontal space between items in pixels', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_space_between_items_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_space_between_items_custom_1512',
					'title'       => esc_html__( 'Custom Horizontal Spacing - 1512', 'warren-core' ),
					'description' => esc_html__( 'Enter horizontal space between items in pixels below 1512px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_space_between_items_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_space_between_items_custom_1200',
					'title'       => esc_html__( 'Custom Horizontal Spacing - 1200', 'warren-core' ),
					'description' => esc_html__( 'Enter horizontal space between items in pixels below 1200px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_space_between_items_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_space_between_items_custom_880',
					'title'       => esc_html__( 'Custom Horizontal Spacing - 880', 'warren-core' ),
					'description' => esc_html__( 'Enter horizontal space between items in pixels below 880px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$section_columns->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_portfolio_vertical_space_between_items',
					'title'      => esc_html__( 'Items Vertical Spacing', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'items_space' ),
				)
			);

			$portfolio_vertical_space_between_items_row = $section_columns->add_row_element(
				array(
					'name'       => 'qodef_portfolio_vertical_space_between_items_row',
					'dependency' => array(
						'show' => array(
							'qodef_portfolio_vertical_space_between_items' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$portfolio_vertical_space_between_items_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_vertical_space_between_items_custom',
					'title'       => esc_html__( 'Custom Vertical Spacing', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_vertical_space_between_items_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_vertical_space_between_items_custom_1512',
					'title'       => esc_html__( 'Custom Vertical Spacing - 1512', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 1512px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_vertical_space_between_items_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_vertical_space_between_items_custom_1200',
					'title'       => esc_html__( 'Custom Vertical Spacing - 1200', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 1200px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_vertical_space_between_items_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_vertical_space_between_items_custom_880',
					'title'       => esc_html__( 'Custom Vertical Spacing - 880', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 880px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$section_media = $general_tab->add_section_element(
				array(
					'name'        => 'qodef_portfolio_media_section',
					'title'       => esc_html__( 'Media Settings', 'warren-core' ),
					'description' => esc_html__( 'Media that will be displayed on portfolio page', 'warren-core' ),
					'dependency'  => array(
						'hide' => array(
							'qodef_portfolio_single_layout' => array(
								'values'        => array(
									'custom',
								),
								'default_value' => '',
							),
						),
					),
				)
			);

			$media_repeater = $section_media->add_repeater_element(
				array(
					'name'        => 'qodef_portfolio_media',
					'title'       => esc_html__( 'Media Items', 'warren-core' ),
					'description' => esc_html__( 'Enter media items for this portfolio', 'warren-core' ),
					'button_text' => esc_html__( 'Add Media', 'warren-core' ),
				)
			);

			$media_repeater->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_media_type',
					'title'         => esc_html__( 'Media Item Type', 'warren-core' ),
					'options'       => array(
						'gallery' => esc_html__( 'Gallery', 'warren-core' ),
						'image'   => esc_html__( 'Image', 'warren-core' ),
						'video'   => esc_html__( 'Video', 'warren-core' ),
						'audio'   => esc_html__( 'Audio', 'warren-core' ),
					),
					'default_value' => 'gallery',
				)
			);

			$media_repeater->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_portfolio_gallery',
					'title'      => esc_html__( 'Upload Portfolio Images', 'warren-core' ),
					'multiple'   => 'yes',
					'dependency' => array(
						'show' => array(
							'qodef_portfolio_media_type' => array(
								'values'        => 'gallery',
								'default_value' => 'gallery',
							),
						),
					),
				)
			);

			$media_repeater->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_portfolio_image',
					'title'      => esc_html__( 'Upload Portfolio Image', 'warren-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_portfolio_media_type' => array(
								'values'        => 'image',
								'default_value' => 'gallery',
							),
						),
					),
				)
			);

			$media_repeater->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_video',
					'title'       => esc_html__( 'Video URL', 'warren-core' ),
					'description' => esc_html__( 'Enter your video URL', 'warren-core' ),
					'dependency'  => array(
						'show' => array(
							'qodef_portfolio_media_type' => array(
								'values'        => 'video',
								'default_value' => 'gallery',
							),
						),
					),
				)
			);

			$media_repeater->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_audio',
					'title'       => esc_html__( 'Audio URL', 'warren-core' ),
					'description' => esc_html__( 'Enter your audio URL', 'warren-core' ),
					'dependency'  => array(
						'show' => array(
							'qodef_portfolio_media_type' => array(
								'values'        => 'audio',
								'default_value' => 'gallery',
							),
						),
					),
				)
			);

			$section_info = $general_tab->add_section_element(
				array(
					'name'        => 'qodef_portfolio_info_section',
					'title'       => esc_html__( 'Info Settings', 'warren-core' ),
					'description' => esc_html__( 'Info that will be displayed on portfolio page', 'warren-core' ),
				)
			);

			$info_items_repeater = $section_info->add_repeater_element(
				array(
					'name'        => 'qodef_portfolio_info_items',
					'title'       => esc_html__( 'Info Items', 'warren-core' ),
					'description' => esc_html__( 'Enter additional info for portoflio item', 'warren-core' ),
					'button_text' => esc_html__( 'Add Item', 'warren-core' ),
				)
			);

			$info_items_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_info_item_label',
					'title'      => esc_html__( 'Item Label', 'warren-core' ),
				)
			);

			$info_items_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_info_item_value',
					'title'      => esc_html__( 'Item Text', 'warren-core' ),
				)
			);

			$info_items_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_info_item_link',
					'title'      => esc_html__( 'Item Link', 'warren-core' ),
				)
			);

			$info_items_repeater->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_info_item_target',
					'title'      => esc_html__( 'Item Target', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'link_target' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_portfolio_meta_box_map', $page, $general_tab );
		}
	}

	add_action( 'warren_core_action_default_meta_boxes_init', 'warren_core_add_portfolio_single_meta_box' );
}

if ( ! function_exists( 'warren_core_include_general_meta_boxes_for_portfolio_single' ) ) {
	/**
	 * Function that add general meta box options for this module
	 */
	function warren_core_include_general_meta_boxes_for_portfolio_single() {
		$callbacks = warren_core_general_meta_box_callbacks();

		if ( ! empty( $callbacks ) ) {
			foreach ( $callbacks as $module => $callback ) {

				if ( 'page-sidebar' !== $module ) {
					add_action( 'warren_core_action_after_portfolio_meta_box_map', $callback );
				}
			}
		}
	}

	add_action( 'warren_core_action_default_meta_boxes_init', 'warren_core_include_general_meta_boxes_for_portfolio_single', 8 ); // Permission 8 is set in order to load it before default meta box function
}
