<?php

if ( ! function_exists( 'warren_core_add_team_single_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_team_single_meta_box() {
		$qode_framework = qode_framework_get_framework_root();
		$has_single     = warren_core_team_has_single();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'team' ),
				'type'  => 'meta',
				'slug'  => 'team',
				'title' => esc_html__( 'Team Single', 'warren-core' ),
			)
		);

		if ( $page ) {
			$section = $page->add_section_element(
				array(
					'name'        => 'qodef_team_general_section',
					'title'       => esc_html__( 'General Settings', 'warren-core' ),
					'description' => esc_html__( 'General information about team member.', 'warren-core' ),
				)
			);

			if ( $has_single ) {
				$section->add_field_element(
					array(
						'field_type'  => 'select',
						'name'        => 'qodef_team_single_layout',
						'title'       => esc_html__( 'Single Layout', 'warren-core' ),
						'description' => esc_html__( 'Choose default layout for team single', 'warren-core' ),
						'options'     => array(
							'' => esc_html__( 'Default', 'warren-core' ),
						),
					)
				);
			}

			$section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_team_member_role',
					'title'       => esc_html__( 'Role', 'warren-core' ),
					'description' => esc_html__( 'Enter team member role', 'warren-core' ),
				)
			);

			$social_icons_repeater = $section->add_repeater_element(
				array(
					'name'        => 'qodef_team_member_social_icons',
					'title'       => esc_html__( 'Social Networks', 'warren-core' ),
					'description' => esc_html__( 'Populate team member social networks info', 'warren-core' ),
					'button_text' => esc_html__( 'Add New Network', 'warren-core' ),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_team_member_icon_or_textual',
					'title'         => esc_html__( 'Social network type', 'warren-core' ),
					'options'       => array(
						'textual' => esc_html__( 'Textual', 'warren-core' ),
						'icon'    => esc_html__( 'Icon', 'warren-core' ),
					),
					'default_value' => 'textual',
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'iconpack',
					'name'       => 'qodef_team_member_icon',
					'title'      => esc_html__( 'Icon', 'warren-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_team_member_icon_or_textual' => array(
								'values'        => 'icon',
								'default_value' => '',
							),
						),
					),
				)
			);
			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_team_member_network_text',
					'title'      => esc_html__( 'Social Network Text', 'warren-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_team_member_icon_or_textual' => array(
								'values'        => 'textual',
								'default_value' => '',
							),
						),
					),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_team_member_icon_link',
					'title'      => esc_html__( 'Icon Link', 'warren-core' ),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_team_member_icon_target',
					'title'      => esc_html__( 'Icon Target', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'link_target' ),
				)
			);

			if ( $has_single ) {
				$section->add_field_element(
					array(
						'field_type'  => 'date',
						'name'        => 'qodef_team_member_birth_date',
						'title'       => esc_html__( 'Birth Date', 'warren-core' ),
						'description' => esc_html__( 'Enter team member birth date', 'warren-core' ),
					)
				);

				$section->add_field_element(
					array(
						'field_type'  => 'text',
						'name'        => 'qodef_team_member_email',
						'title'       => esc_html__( 'E-mail', 'warren-core' ),
						'description' => esc_html__( 'Enter team member e-mail address', 'warren-core' ),
					)
				);

				$section->add_field_element(
					array(
						'field_type'  => 'text',
						'name'        => 'qodef_team_member_address',
						'title'       => esc_html__( 'Address', 'warren-core' ),
						'description' => esc_html__( 'Enter team member address', 'warren-core' ),
					)
				);

				$section->add_field_element(
					array(
						'field_type'  => 'text',
						'name'        => 'qodef_team_member_education',
						'title'       => esc_html__( 'Education', 'warren-core' ),
						'description' => esc_html__( 'Enter team member education', 'warren-core' ),
					)
				);

				$section->add_field_element(
					array(
						'field_type'  => 'file',
						'name'        => 'qodef_team_member_resume',
						'title'       => esc_html__( 'Resume', 'warren-core' ),
						'description' => esc_html__( 'Upload team member resume', 'warren-core' ),
						'args'        => array(
							'allowed_type' => '[application/pdf,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document]',
						),
					)
				);
			}

			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_team_meta_box_map', $page, $has_single );
		}
	}

	add_action( 'warren_core_action_default_meta_boxes_init', 'warren_core_add_team_single_meta_box' );
}
