<?php

if ( ! function_exists( 'warren_core_add_banner_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function warren_core_add_banner_shortcode( $shortcodes ) {
		$shortcodes[] = 'WarrenCore_Banner_Shortcode';

		return $shortcodes;
	}

	add_filter( 'warren_core_filter_register_shortcodes', 'warren_core_add_banner_shortcode' );
}

if ( class_exists( 'WarrenCore_Shortcode' ) ) {
	class WarrenCore_Banner_Shortcode extends WarrenCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'warren_core_filter_banner_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'warren_core_filter_banner_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( WARREN_CORE_SHORTCODES_URL_PATH . '/banner' );
			$this->set_base( 'warren_core_banner' );
			$this->set_name( esc_html__( 'Banner', 'warren-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds banner element', 'warren-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'warren-core' ),
				)
			);

			$options_map = warren_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'warren-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array(
						'map_for_page_builder' => $options_map['visibility'],
						'map_for_widget'       => $options_map['visibility'],
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'link_url',
					'title'      => esc_html__( 'Link', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'link_target',
					'title'         => esc_html__( 'Link Target', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'warren-core' ),
					'default_value' => esc_html__( 'Title Text', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h4',
					'group'         => esc_html__( 'Title Style', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'warren-core' ),
					'group'      => esc_html__( 'Title Style', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'title_margin_top',
					'title'      => esc_html__( 'Title Margin Top', 'warren-core' ),
					'group'      => esc_html__( 'Title Style', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'title_text_transform',
					'title'      => esc_html__( 'Title Text Transform', 'warren-core' ),
					'group'      => esc_html__( 'Title Style', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'text_transform' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'subtitle',
					'title'      => esc_html__( 'Subtitle', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'subtitle_tag',
					'title'         => esc_html__( 'Subtitle Tag', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h5',
					'group'         => esc_html__( 'Subtitle Style', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'warren-core' ),
					'group'      => esc_html__( 'Subtitle Style', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'subtitle_margin_top',
					'title'      => esc_html__( 'Subtitle Margin Top', 'warren-core' ),
					'group'      => esc_html__( 'Subtitle Style', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'textarea',
					'name'       => 'text_field',
					'title'      => esc_html__( 'Text', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color_all',
					'title'      => esc_html__( 'Background Color', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'inner_image',
					'title'      => esc_html__( 'Inside Image', 'warren-core' ),
					'dependency' => array(
						'hide' => array(
							'layout' => array(
								'values'        => 'link-overlay',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'space_between_margin_top',
					'title'      => esc_html__( 'Space Between', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'image_border',
					'title'      => esc_html__( 'Image Border Radius', 'warren-core' ),
					'dependency' => array(
						'hide' => array(
							'layout' => array(
								'values'        => 'link-overlay',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'text_tag',
					'title'         => esc_html__( 'Text Tag', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'p',
					'group'         => esc_html__( 'Text Style', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'warren-core' ),
					'group'      => esc_html__( 'Text Style', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'warren-core' ),
					'group'      => esc_html__( 'Text Style', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_text_field',
					'title'      => esc_html__( 'Custom Text', 'warren-core' ),
					'dependency' => array(
						'hide' => array(
							'layout' => array(
								'values'        => 'link-button',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'custom_text_tag',
					'title'         => esc_html__( 'Custom Text Tag', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h3',
					'group'         => esc_html__( 'Custom Text Style', 'warren-core' ),
					'dependency' => array(
						'hide' => array(
							'layout' => array(
								'values'        => 'link-button',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'custom_text_color',
					'title'      => esc_html__( 'Custom Text Color', 'warren-core' ),
					'group'      => esc_html__( 'Custom Text Style', 'warren-core' ),
					'dependency' => array(
						'hide' => array(
							'layout' => array(
								'values'        => 'link-button',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_text_margin_top',
					'title'      => esc_html__( 'Custom Text Margin Top', 'warren-core' ),
					'group'      => esc_html__( 'Custom Text Style', 'warren-core' ),
					'dependency' => array(
						'hide' => array(
							'layout' => array(
								'values'        => 'link-button',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'warren_core_button',
					'exclude'           => array( 'custom_class', 'link', 'target' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'warren-core' ),

					),
					'dependency'        => array(
						'show' => array(
							'layout' => array(
								'values'        => 'link-button',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'warren_core_banner', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']     = $this->get_holder_classes( $atts );
			$atts['title_styles']       = $this->get_title_styles( $atts );
			$atts['subtitle_styles']    = $this->get_subtitle_styles( $atts );
			$atts['text_styles']        = $this->get_text_styles( $atts );
			$atts['custom_text_styles'] = $this->get_custom_text_styles( $atts );
			$atts['button_params']      = $this->generate_button_params( $atts );
			$atts['inner_image_style']  = $this->get_inner_image( $atts );
			$atts['content_classes']    = $this->get_content_class( $atts );
			$atts['image_style']        = $this->get_image_style( $atts );

			return warren_core_get_template_part( 'shortcodes/banner', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-banner';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';

			return implode( ' ', $holder_classes );
		}

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['title_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['title_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['title_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['title_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			if ( ! empty( $atts['title_text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['title_text_transform'];
			}

			return $styles;
		}

		private function get_subtitle_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['subtitle_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['subtitle_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['subtitle_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['subtitle_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['subtitle_color'] ) ) {
				$styles[] = 'color: ' . $atts['subtitle_color'];
			}

			return $styles;
		}

		private function get_text_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['text_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			return $styles;
		}

		private function get_custom_text_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['custom_text_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['custom_text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['custom_text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['custom_text_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['custom_text_color'] ) ) {
				$styles[] = 'color: ' . $atts['custom_text_color'];
			}

			return $styles;
		}

		private function get_inner_image( $atts ) {
			$styles = array();

			if ( ! empty( $atts['image_border'] ) ) {
				$styles[] = 'border-radius: ' . $atts['image_border'];
			}

			return $styles;
		}

		private function get_content_class( $atts ) {
			$styles = array();

			if ( ! empty( $atts['background_color_all'] ) ) {
				$styles[] = 'background-color: ' . $atts['background_color_all'];
			}

			return $styles;
		}

		private function get_image_style( $atts ) {
			$styles = array();

			if ( '' !== $atts['space_between_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['space_between_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['space_between_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['space_between_margin_top'] ) . 'px';
				}
			}

			return $styles;
		}

		private function generate_button_params( $atts ) {
			$params = $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'warren_core_button',
					'exclude'        => array( 'custom_class', 'link', 'target' ),
					'atts'           => $atts,
				)
			);

			$params['link']   = ! empty( $atts['link_url'] ) ? $atts['link_url'] : '';
			$params['target'] = ! empty( $atts['link_target'] ) ? $atts['link_target'] : '';

			return $params;
		}
	}
}
