<?php

if ( ! function_exists( 'warren_core_add_icon_list_item_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function warren_core_add_icon_list_item_widget( $widgets ) {
		$widgets[] = 'WarrenCore_Icon_List_Item_Widget';

		return $widgets;
	}

	add_filter( 'warren_core_filter_register_widgets', 'warren_core_add_icon_list_item_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class WarrenCore_Icon_List_Item_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'warren_core_icon_list_item',
					'exclude'        => array( 'icon_type', 'custom_icon' ),
				)
			);
			if ( $widget_mapped ) {
				$this->set_base( 'warren_core_icon_list_item' );
				$this->set_name( esc_html__( 'Warren Icon List Item', 'warren-core' ) );
				$this->set_description( esc_html__( 'Add a icon list item element into widget areas', 'warren-core' ) );
			}
		}

		public function render( $atts ) {
			echo WarrenCore_Icon_List_Item_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
