<?php

if ( ! function_exists( 'warren_core_add_icon_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function warren_core_add_icon_widget( $widgets ) {
		$widgets[] = 'WarrenCore_Icon_Widget';

		return $widgets;
	}

	add_filter( 'warren_core_filter_register_widgets', 'warren_core_add_icon_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class WarrenCore_Icon_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'warren_core_icon',
				)
			);

			if ( $widget_mapped ) {
				$this->set_base( 'warren_core_icon' );
				$this->set_name( esc_html__( 'Warren Icon', 'warren-core' ) );
				$this->set_description( esc_html__( 'Add a icon element into widget areas', 'warren-core' ) );
			}
		}

		public function render( $atts ) {
			echo WarrenCore_Icon_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
