<?php

if ( ! function_exists( 'warren_core_add_separator_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function warren_core_add_separator_widget( $widgets ) {
		$widgets[] = 'WarrenCore_Separator_Widget';

		return $widgets;
	}

	add_filter( 'warren_core_filter_register_widgets', 'warren_core_add_separator_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class WarrenCore_Separator_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'warren_core_separator',
				)
			);

			if ( $widget_mapped ) {
				$this->set_base( 'warren_core_separator' );
				$this->set_name( esc_html__( 'Warren Separator', 'warren-core' ) );
				$this->set_description( esc_html__( 'Add a separator element into widget areas', 'warren-core' ) );
			}
		}

		public function render( $atts ) {
			echo WarrenCore_Separator_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
