<?php

if ( ! function_exists( 'warren_core_add_single_image_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function warren_core_add_single_image_widget( $widgets ) {
		$widgets[] = 'WarrenCore_Single_Image_Widget';

		return $widgets;
	}

	add_filter( 'warren_core_filter_register_widgets', 'warren_core_add_single_image_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class WarrenCore_Single_Image_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'warren_core_single_image',
					'exclude'        => array( 'custom_class', 'parallax_item' ),
				)
			);
			if ( $widget_mapped ) {
				$this->set_base( 'warren_core_single_image' );
				$this->set_name( esc_html__( 'Warren Single Image', 'warren-core' ) );
				$this->set_description( esc_html__( 'Add a single image element into widget areas', 'warren-core' ) );
			}
		}

		public function render( $atts ) {
			echo WarrenCore_Single_Image_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
