<?php

if ( ! function_exists( 'warren_core_add_page_sidebar_meta_box' ) ) {
	/**
	 * Function that add general meta box options for this module
	 *
	 * @param object $page
	 */
	function warren_core_add_page_sidebar_meta_box( $page ) {

		if ( $page ) {

			$sidebar_tab = $page->add_tab_element(
				array(
					'name'        => 'tab-sidebar',
					'icon'        => 'fa fa-cog',
					'title'       => esc_html__( 'Sidebar Settings', 'warren-core' ),
					'description' => esc_html__( 'Sidebar layout settings', 'warren-core' ),
				)
			);

			$sidebar_tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_sidebar_layout',
					'title'       => esc_html__( 'Sidebar Layout', 'warren-core' ),
					'description' => esc_html__( 'Choose a sidebar layout', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'sidebar_layouts' ),
				)
			);

			$custom_sidebars = warren_core_get_custom_sidebars();
			if ( ! empty( $custom_sidebars ) && count( $custom_sidebars ) > 1 ) {
				$sidebar_tab->add_field_element(
					array(
						'field_type'  => 'select',
						'name'        => 'qodef_page_custom_sidebar',
						'title'       => esc_html__( 'Custom Sidebar', 'warren-core' ),
						'description' => esc_html__( 'Choose a custom sidebar', 'warren-core' ),
						'options'     => $custom_sidebars,
					)
				);
			}

			$sidebar_tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_sidebar_grid_gutter',
					'title'       => esc_html__( 'Set Grid Gutter', 'warren-core' ),
					'description' => esc_html__( 'Choose grid gutter size to set space between content and sidebar', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'items_space' ),
				)
			);

			$page_sidebar_grid_gutter_row = $sidebar_tab->add_row_element(
				array(
					'name'       => 'qodef_page_sidebar_grid_gutter_row',
					'dependency' => array(
						'show' => array(
							'qodef_page_sidebar_grid_gutter' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$page_sidebar_grid_gutter_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_sidebar_grid_gutter_custom',
					'title'       => esc_html__( 'Custom Grid Gutter', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$page_sidebar_grid_gutter_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_sidebar_grid_gutter_custom_1512',
					'title'       => esc_html__( 'Custom Grid Gutter - 1512', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 1512px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$page_sidebar_grid_gutter_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_sidebar_grid_gutter_custom_1200',
					'title'       => esc_html__( 'Custom Grid Gutter - 1200', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 1200px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$page_sidebar_grid_gutter_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_sidebar_grid_gutter_custom_880',
					'title'       => esc_html__( 'Custom Grid Gutter - 880', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 880px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_page_sidebar_meta_box_map', $sidebar_tab );
		}
	}

	add_action( 'warren_core_action_after_general_meta_box_map', 'warren_core_add_page_sidebar_meta_box' );
}

if ( ! function_exists( 'warren_core_add_general_page_sidebar_meta_box_callback' ) ) {
	/**
	 * Function that set current meta box callback as general callback functions
	 *
	 * @param array $callbacks
	 *
	 * @return array
	 */
	function warren_core_add_general_page_sidebar_meta_box_callback( $callbacks ) {
		$callbacks['page-sidebar'] = 'warren_core_add_page_sidebar_meta_box';

		return $callbacks;
	}

	add_filter( 'warren_core_filter_general_meta_box_callbacks', 'warren_core_add_general_page_sidebar_meta_box_callback' );
}
