<?php

if ( ! function_exists( 'warren_core_add_social_share_variation_list' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function warren_core_add_social_share_variation_list( $variations ) {
		$variations['list'] = esc_html__( 'List', 'warren-core' );

		return $variations;
	}

	add_filter( 'warren_core_filter_social_share_layouts', 'warren_core_add_social_share_variation_list' );
	add_filter( 'warren_core_filter_social_share_layout_options', 'warren_core_add_social_share_variation_list' );
}

if ( ! function_exists( 'warren_core_set_default_social_share_variation_list' ) ) {
	/**
	 * Function that set default variation layout for this module
	 *
	 * @return string
	 */
	function warren_core_set_default_social_share_variation_list() {
		return 'list';
	}

	add_filter( 'warren_core_filter_social_share_layout_default_value', 'warren_core_set_default_social_share_variation_list' );
}
