<?php

if ( ! function_exists( 'warren_core_add_social_share_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function warren_core_add_social_share_widget( $widgets ) {
		$widgets[] = 'WarrenCore_Social_Share_Widget';

		return $widgets;
	}

	add_filter( 'warren_core_filter_register_widgets', 'warren_core_add_social_share_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class WarrenCore_Social_Share_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'warren_core_social_share',
				)
			);

			if ( $widget_mapped ) {
				$this->set_base( 'warren_core_social_share' );
				$this->set_name( esc_html__( 'Warren Social Share', 'warren-core' ) );
				$this->set_description( esc_html__( 'Add a social share element into widget areas', 'warren-core' ) );
			}
		}

		public function render( $atts ) {
			echo WarrenCore_Social_Share_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
