(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefPredefinedSpinner.init();
		}
	);

	var qodefPredefinedSpinner = {
		holder: '',
		init: function ( isEditMode ) {
			this.holder = $( '#qodef-page-spinner.qodef-layout--predefined' );

			if ( this.holder.length ) {
				qodefPredefinedSpinner.animateSpinner(
					this.holder,
					isEditMode
				);
			}
		},
		animateSpinner: function ( $holder ) {
			var $imagesHolders = $holder.find( '.qodef-m-spinner-image' );

			var startXPos = [-15, 15, -15, 15];
			var startYPos = [-20, -33, 30, 52];

			var tlOutStarted = false;

			var tl = gsap.timeline(
				{
					paused: true,
					onStart: () => {
						$holder.addClass( 'qodef--init' );
					}
				}
			);

			var tlOut = gsap.timeline(
				{
					paused: true,
					onStart: () => {
						tlOutStarted = true;

						var appeared = $( '.qodef--appeared' );

						appeared.removeClass( 'qodef--appeared' );
					},
				}
			);

			$imagesHolders.each(
				( i, el ) => {
					let repeatIteration = 0;

					if ( i === 0 || 3 > 2 ) {
						var childTl = gsap.timeline(
							{
								paused: true,
								repeat: -1,
							}
						);

						childTl
						.from(
							el,
							{
								opacity: 0,
								x: startXPos[i],
								y: startYPos[i],
								ease: 'power2.inOut',
								duration: .7,
							},
						)
						.from(
							$( el ).find( 'img' ),
							{
								scale: 1.26,
								ease: 'power3.out',
								duration: .9,
							},
							'.3'
						)
						.to(
							$holder,
							{
								duration: .9,
								onStart: () => {
									if ( qodefCore.qodefSpinner.windowLoaded && repeatIteration > 0) {
										childTl.pause();

										if ( i === 0 && ! tlOutStarted){
											tlOut.play();
										}

									} else {
										repeatIteration ++;
									}
								}
							},
							'-=.7'
						)
						.to(
							$( el ).find( 'img' ),
							{
								opacity: 0,
								duration: .5,
							},
						);

						tl.add(
							childTl.play(),
							i * .17
						);
					}
				}
			);

			tlOut
			.to(
				$holder,
				{
					'--qode-clip': 100,
					duration: 1.8,
					ease: 'power3.inOut',
					onComplete: () => {
						tl.kill();
						tlOut.kill();
						$holder.addClass('qodef--finished');
					},
				},
			)
			.to(
				$holder,
				{
					onStart: () => {
						qodefCore.qodefAppear.init();
					},
				},
				'.7'
			)

			tl.play();
		},
	};

})( jQuery );
