<?php

if ( ! function_exists( 'warren_membership_add_general_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_membership_add_general_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => WARREN_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'membership',
				'icon'        => 'fa fa-envelope',
				'title'       => esc_html__( 'Membership', 'warren-membership' ),
				'description' => esc_html__( 'Membership Settings', 'warren-membership' ),
			)
		);

		if ( $page ) {

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_membership_enable_privacy_policy',
					'title'       => esc_html__( 'Enable Privacy Policy', 'warren-membership' ),
					'description' => esc_html__( 'If enabled privacy policy text will be displayed on registration form', 'warren-membership' ),
					'options'     => warren_core_get_select_type_options_pool('yes_no')
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_membership_privacy_policy_text',
					'title'       => esc_html__( 'Privacy Policy Text', 'warren-membership' ),
					'description' => esc_html__( 'Enter privacy policy text for registration modal form', 'warren-membership' ),
					'dependency'  => array(
						'hide' => array(
							'qodef_membership_enable_privacy_policy' => array(
								'values'        => 'no',
								'default_value' => 'yes',
							),
						),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_membership_privacy_policy_link',
					'title'       => esc_html__( 'Privacy Policy Link', 'warren-membership' ),
					'description' => esc_html__( 'Choose "Privacy Policy Link" page to link from registration modal form', 'warren-membership' ),
					'options'     => qode_framework_get_pages( true ),
					'dependency'  => array(
						'hide' => array(
							'qodef_membership_enable_privacy_policy' => array(
								'values'        => 'no',
								'default_value' => 'yes',
							),
						),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_membership_privacy_policy_link_text',
					'title'       => esc_html__( 'Privacy Policy Link Text', 'warren-membership' ),
					'description' => esc_html__( 'Enter privacy policy link text for registration modal form. Default value is "privacy policy"', 'warren-membership' ),
					'dependency'  => array(
						'hide' => array(
							'qodef_membership_enable_privacy_policy' => array(
								'values'        => 'no',
								'default_value' => 'yes',
							),
						),
					),
					)
			);

			// Hook to include additional options after module options
			do_action( 'warren_membership_action_after_membership_options_map', $page );
		}
	}

	add_action( 'warren_core_action_default_options_init', 'warren_membership_add_general_options', 70 );
}
