(function ( $ ) {
	'use strict';

	$( document ).on(
		'ready',
		function () {
			qodefGoogleLogin.init();
		}
	);

	$( document ).on(
		'warren_membership_social_login_is_triggered',
		function ( e, $modal, $form, social ) {
			if ( qodefGoogleLogin.isAppIdSet() && social === 'google' ) {
				qodefGoogleLogin.login( $modal, $form, social );
			}
		}
	);

	var qodefGoogleLogin = {
		init: function () {

			if ( qodefGoogleLogin.isAppIdSet() ) {
				qodefGoogleLogin.asyncInit( warrenMembershipGlobal.googleAppId );
			}
		},
		isAppIdSet: function () {
			return typeof warrenMembershipGlobal.googleAppId !== 'undefined' && warrenMembershipGlobal.googleAppId !== '';
		},
		asyncInit: function ( appID ) {

			if ( appID !== '' ) {
				google.accounts.id.initialize(
					{
						client_id: appID,
					}
				);
			}
		},
		login: function ( $modal, $form, social ) {

			var client = google.accounts.oauth2.initTokenClient(
				{
					client_id: warrenMembershipGlobal.googleAppId,
					scope: 'https://www.googleapis.com/auth/userinfo.profile',
					prompt: '',
					callback: function ( response ) {
						qodefGoogleLogin.signIn( response, $modal, $form, social );
					},
				}
			);

			client.requestAccessToken();
		},
		signIn: function ( response, $modal, $form, social ) {
			if ( ! response || ! response.access_token ) {
				return;
			}

			var url = 'https://people.googleapis.com/v1/people/me?personFields=names,emailAddresses,photos&access_token=' + encodeURIComponent( response.access_token );

			fetch( url ).then(
				function ( response ) {
					return response.text();
				}
			).then(
				function ( responseObject ) {

					if ( responseObject && responseObject.length ) {
						qodefGoogleLogin.getUserData( responseObject, $modal, $form, social );
					}
				}
			);
		},
		getUserData: function ( responseObject, $modal, $form, social ) {

			if ( responseObject ) {
				responseObject = JSON.parse( responseObject );

				var userData = {
					id: responseObject?.resourceName.replace( /[A-Za-z\\/]/g, '' ),
					name: responseObject?.names[0]?.displayName,
					email: responseObject?.emailAddresses[0]?.value,
					image: responseObject?.photos[0]?.url,
				};

				if ( ! $form.hasClass( 'qodef--loading' ) ) {
					$modal.triggerRequest( $form, social, userData );
				}
			}
		}
	};

})( jQuery );
