<?php

if ( ! function_exists( 'warren_core_add_general_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_general_options( $page ) {

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_main_color',
					'title'       => esc_html__( 'Main Color', 'warren-core' ),
					'description' => esc_html__( 'Choose the most dominant theme color', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_page_background_color',
					'title'       => esc_html__( 'Page Background Color', 'warren-core' ),
					'description' => esc_html__( 'Set background color', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_page_background_image',
					'title'       => esc_html__( 'Page Background Image', 'warren-core' ),
					'description' => esc_html__( 'Set background image', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_repeat',
					'title'       => esc_html__( 'Page Background Image Repeat', 'warren-core' ),
					'description' => esc_html__( 'Set background image repeat', 'warren-core' ),
					'options'     => array(
						''          => esc_html__( 'Default', 'warren-core' ),
						'no-repeat' => esc_html__( 'No Repeat', 'warren-core' ),
						'repeat'    => esc_html__( 'Repeat', 'warren-core' ),
						'repeat-x'  => esc_html__( 'Repeat-x', 'warren-core' ),
						'repeat-y'  => esc_html__( 'Repeat-y', 'warren-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_size',
					'title'       => esc_html__( 'Page Background Image Size', 'warren-core' ),
					'description' => esc_html__( 'Set background image size', 'warren-core' ),
					'options'     => array(
						''        => esc_html__( 'Default', 'warren-core' ),
						'contain' => esc_html__( 'Contain', 'warren-core' ),
						'cover'   => esc_html__( 'Cover', 'warren-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_attachment',
					'title'       => esc_html__( 'Page Background Image Attachment', 'warren-core' ),
					'description' => esc_html__( 'Set background image attachment', 'warren-core' ),
					'options'     => array(
						''       => esc_html__( 'Default', 'warren-core' ),
						'fixed'  => esc_html__( 'Fixed', 'warren-core' ),
						'scroll' => esc_html__( 'Scroll', 'warren-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_content_padding',
					'title'       => esc_html__( 'Page Content Padding', 'warren-core' ),
					'description' => esc_html__( 'Set padding that will be applied for page content in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_content_padding_mobile',
					'title'       => esc_html__( 'Page Content Padding Mobile', 'warren-core' ),
					'description' => esc_html__( 'Set padding that will be applied for page content on mobile screens (1200px and below) in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_boxed',
					'title'         => esc_html__( 'Boxed Layout', 'warren-core' ),
					'description'   => esc_html__( 'Set boxed layout', 'warren-core' ),
					'default_value' => 'no',
				)
			);

			$boxed_section = $page->add_section_element(
				array(
					'name'       => 'qodef_boxed_section',
					'title'      => esc_html__( 'Boxed Layout Section', 'warren-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_boxed' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_boxed_background_color',
					'title'       => esc_html__( 'Boxed Background Color', 'warren-core' ),
					'description' => esc_html__( 'Set boxed background color', 'warren-core' ),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_boxed_background_pattern',
					'title'       => esc_html__( 'Boxed Background Pattern', 'warren-core' ),
					'description' => esc_html__( 'Set boxed background pattern', 'warren-core' ),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_boxed_background_pattern_behavior',
					'title'       => esc_html__( 'Boxed Background Pattern Behavior', 'warren-core' ),
					'description' => esc_html__( 'Set boxed background pattern behavior', 'warren-core' ),
					'options'     => array(
						'fixed'  => esc_html__( 'Fixed', 'warren-core' ),
						'scroll' => esc_html__( 'Scroll', 'warren-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_passepartout',
					'title'         => esc_html__( 'Passepartout', 'warren-core' ),
					'description'   => esc_html__( 'Enabling this option will display a passepartout around website content', 'warren-core' ),
					'default_value' => 'no',
				)
			);

			$passepartout_section = $page->add_section_element(
				array(
					'name'       => 'qodef_passepartout_section',
					'title'      => esc_html__( 'Passepartout Section', 'warren-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_passepartout' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_passepartout_color',
					'title'       => esc_html__( 'Passepartout Color', 'warren-core' ),
					'description' => esc_html__( 'Choose background color for passepartout', 'warren-core' ),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_passepartout_image',
					'title'       => esc_html__( 'Passepartout Background Image', 'warren-core' ),
					'description' => esc_html__( 'Set background image for passepartout', 'warren-core' ),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_passepartout_size',
					'title'       => esc_html__( 'Passepartout Size', 'warren-core' ),
					'description' => esc_html__( 'Enter size amount for passepartout', 'warren-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'warren-core' ),
					),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_passepartout_size_responsive',
					'title'       => esc_html__( 'Passepartout Responsive Size', 'warren-core' ),
					'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (1200px and below)', 'warren-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'warren-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_content_width',
					'title'         => esc_html__( 'Initial Width of Content', 'warren-core' ),
					'description'   => esc_html__( 'Choose the initial width of content which is in grid (applies to pages set to "Default Template" and rows set to "In Grid")', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'content_width', false ),
					'default_value' => '1100',
				)
			);

			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_general_options_map', $page );

			$page->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_custom_js',
					'title'       => esc_html__( 'Custom JS', 'warren-core' ),
					'description' => esc_html__( 'Enter your custom JavaScript here', 'warren-core' ),
				)
			);
		}
	}

	add_action( 'warren_core_action_default_options_init', 'warren_core_add_general_options', warren_core_get_admin_options_map_position( 'general' ) );
}
