<?php

if ( ! function_exists( 'warren_core_add_header_options' ) ) {
	/**
	 * Function that add header options for this module
	 */
	function warren_core_add_header_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => WARREN_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'layout'      => 'tabbed',
				'slug'        => 'header',
				'icon'        => 'fa fa-cog',
				'title'       => esc_html__( 'Header', 'warren-core' ),
				'description' => esc_html__( 'Global Header Options', 'warren-core' ),
			)
		);

		if ( $page ) {
			$general_tab = $page->add_tab_element(
				array(
					'name'  => 'tab-header-general',
					'icon'  => 'fa fa-cog',
					'title' => esc_html__( 'General Settings', 'warren-core' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'    => 'radio',
					'name'          => 'qodef_header_layout',
					'title'         => esc_html__( 'Header Layout', 'warren-core' ),
					'description'   => esc_html__( 'Choose a header layout to set for your website', 'warren-core' ),
					'args'          => array( 'images' => true ),
					'options'       => apply_filters( 'warren_core_filter_header_layout_option', array() ),
					'default_value' => apply_filters( 'warren_core_filter_header_layout_default_option_value', '' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_header_skin',
					'title'       => esc_html__( 'Header Skin', 'warren-core' ),
					'description' => esc_html__( 'Choose a predefined header style for header elements', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'header_skin', false ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_header_widgets_separator',
					'title'         => esc_html__( 'Enable Widgets Separator', 'warren-core' ),
					'description'   => esc_html__( 'Use this option to enable/disable widgets separator', 'warren-core' ),
					'default_value' => 'no',
				)
			);

			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_header_options_map', $page, $general_tab );
		}
	}

	add_action( 'warren_core_action_default_options_init', 'warren_core_add_header_options', warren_core_get_admin_options_map_position( 'header' ) );
}
