<?php

if ( ! function_exists( 'warren_core_add_centered_header_options' ) ) {
	/**
	 * Function that add additional header layout options
	 *
	 * @param object $page
	 * @param array  $general_header_tab
	 */
	function warren_core_add_centered_header_options( $page, $general_header_tab ) {

		$section = $general_header_tab->add_section_element(
			array(
				'name'       => 'qodef_centered_header_section',
				'title'      => esc_html__( 'Centered Header', 'warren-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => 'centered',
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_centered_header_height',
				'title'       => esc_html__( 'Header Height', 'warren-core' ),
				'description' => esc_html__( 'Enter header height', 'warren-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'warren-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_centered_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'warren-core' ),
				'description' => esc_html__( 'Enter header background color', 'warren-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_centered_header_border_color',
				'title'       => esc_html__( 'Header Border Color', 'warren-core' ),
				'description' => esc_html__( 'Enter header border color', 'warren-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_centered_header_border_width',
				'title'       => esc_html__( 'Header Border Width', 'warren-core' ),
				'description' => esc_html__( 'Enter header border width size', 'warren-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'warren-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_centered_header_border_style',
				'title'       => esc_html__( 'Header Border Style', 'warren-core' ),
				'description' => esc_html__( 'Choose header border style', 'warren-core' ),
				'options'     => warren_core_get_select_type_options_pool( 'border_style' ),
			)
		);
	}

	add_action( 'warren_core_action_after_header_options_map', 'warren_core_add_centered_header_options', 10, 2 );
}
