<?php

if ( ! function_exists( 'warren_core_add_minimal_header_meta' ) ) {
	/**
	 * Function that add additional header layout meta box options
	 *
	 * @param object $page
	 */
	function warren_core_add_minimal_header_meta( $page ) {

		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_minimal_header_section',
				'title'      => esc_html__( 'Minimal Header', 'warren-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => 'minimal',
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_minimal_header_in_grid',
				'title'         => esc_html__( 'Content in Grid', 'warren-core' ),
				'description'   => esc_html__( 'Set content to be in grid', 'warren-core' ),
				'default_value' => '',
				'options'       => warren_core_get_select_type_options_pool( 'no_yes' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_minimal_header_height',
				'title'       => esc_html__( 'Header Height', 'warren-core' ),
				'description' => esc_html__( 'Enter header height', 'warren-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'warren-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_minimal_header_side_padding',
				'title'       => esc_html__( 'Header Side Padding', 'warren-core' ),
				'description' => esc_html__( 'Enter side padding for header area', 'warren-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'warren-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_minimal_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'warren-core' ),
				'description' => esc_html__( 'Enter header background color', 'warren-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_minimal_header_border_color',
				'title'       => esc_html__( 'Header Border Color', 'warren-core' ),
				'description' => esc_html__( 'Enter header border color', 'warren-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_minimal_header_border_width',
				'title'       => esc_html__( 'Header Border Width', 'warren-core' ),
				'description' => esc_html__( 'Enter header border width size', 'warren-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'warren-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_minimal_header_border_style',
				'title'       => esc_html__( 'Header Border Style', 'warren-core' ),
				'description' => esc_html__( 'Choose header border style', 'warren-core' ),
				'options'     => warren_core_get_select_type_options_pool( 'border_style' ),
			)
		);
	}

	add_action( 'warren_core_action_after_page_header_meta_map', 'warren_core_add_minimal_header_meta' );
}
